package eu.dnetlib.msro.workflows.nodes.hadoop;

import java.util.Map;

import eu.dnetlib.enabling.resultset.client.ResultSetClient;
import eu.dnetlib.msro.workflows.procs.Env;
import eu.dnetlib.msro.workflows.procs.Token;
import eu.dnetlib.rmi.common.ResultSet;
import eu.dnetlib.rmi.data.hadoop.HadoopBlackboardActions;
import eu.dnetlib.rmi.data.hadoop.HadoopService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;

import eu.dnetlib.enabling.tools.blackboard.BlackboardJob;
import eu.dnetlib.msro.workflows.nodes.BlackboardJobNode;
import eu.dnetlib.msro.workflows.nodes.blackboard.BlackboardWorkflowJobListener;
import eu.dnetlib.msro.workflows.util.ResultsetProgressProvider;
import eu.dnetlib.msro.workflows.util.WorkflowsConstants;

public class StoreHdfsRecordsJobNode extends BlackboardJobNode {

	private static final Log log = LogFactory.getLog(StoreHdfsRecordsJobNode.class); // NOPMD by marko on 11/24/08 5:02 PM

	private String inputEprParam;
	private String hdfsPath;
	private String cluster;

	@Autowired
	private ResultSetClient resultSetClient;

	@Override
	protected String obtainServiceId(final Env env) {
		return getServiceLocator().getServiceId(HadoopService.class);
	}

	@Override
	protected void prepareJob(final BlackboardJob job, final Token token) throws Exception {
		log.info("Invoking blackboard method");


		final ResultSet<?> rs = token.getEnv().getAttribute(inputEprParam, ResultSet.class);
		token.setProgressProvider(new ResultsetProgressProvider(rs, resultSetClient));

		job.setAction(HadoopBlackboardActions.IMPORT_EPR_HDFS.toString());
		job.getParameters().put("input_epr", rs.toJson());
		job.getParameters().put("path", getHdfsPath());
		job.getParameters().put("cluster", getCluster());
	}

	@Override
	protected BlackboardWorkflowJobListener generateBlackboardListener(final Token token) {
		return new BlackboardWorkflowJobListener(token) {

			@Override
			protected void responseToEnv(final Env env, final Map<String, String> responseParams) {
				env.setAttribute(WorkflowsConstants.MAIN_LOG_PREFIX + getNodeName() + ":count", responseParams.get("count"));
			}
		};
	}

	public String getInputEprParam() {
		return inputEprParam;
	}

	public void setInputEprParam(final String inputEprParam) {
		this.inputEprParam = inputEprParam;
	}


	public String getCluster() {
		return cluster;
	}

	public void setCluster(final String cluster) {
		this.cluster = cluster;
	}

	public String getHdfsPath() {
		return hdfsPath;
	}

	public void setHdfsPath(final String hdfsPath) {
		this.hdfsPath = hdfsPath;
	}
}
