package eu.dnetlib.msro.workflows.nodes.hostedby;

import java.io.StringReader;
import java.util.Map;
import java.util.function.UnaryOperator;

import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.io.SAXReader;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

import com.google.common.collect.Maps;

import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.enabling.resultset.client.ResultSetClient;
import eu.dnetlib.enabling.resultset.factory.ResultSetFactory;
import eu.dnetlib.msro.workflows.graph.Arc;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;
import eu.dnetlib.msro.workflows.procs.Env;
import eu.dnetlib.rmi.common.ResultSet;
import eu.dnetlib.rmi.data.DatabaseException;
import eu.dnetlib.rmi.data.DatabaseService;

public class PatchHostedByJobNode extends SimpleJobNode {

	private String inputEprParam;
	private String outputEprParam;

	@Value("${dnet.openaire.db.name}")
	private String dbName;
	private String countersParam;
	private String hostedbyMapTable;
	private String xpathEntry;
	private String overrideDataSourceId;

	@Autowired
	private UniqueServiceLocator serviceLocator;
	@Autowired
	private ResultSetFactory resultSetFactory;
	@Autowired
	private ResultSetClient resultSetClient;

	private static final Log log = LogFactory.getLog(PatchHostedByJobNode.class);

	/** {@inheritDoc} */
	@Override
	protected String execute(final Env env) throws Exception {
		final ResultSet<?> inputEpr = env.getAttribute(this.inputEprParam, ResultSet.class);
		final HostedByCounters counters = new HostedByCounters();
		String datasourceId;
		if (StringUtils.isEmpty(this.overrideDataSourceId)) {
			datasourceId = env.getAttribute("parentDatasourceId", String.class);
		} else {
			datasourceId = getOverrideDataSourceId();
		}

		final UnaryOperator<String> mapper = new PatchHostedBy(loadHostedByMap(datasourceId), getXpathEntry(), counters);
		final ResultSet<String> epr = this.resultSetFactory.map(inputEpr, String.class, mapper);

		env.setAttribute(this.outputEprParam, epr);
		env.setAttribute(this.countersParam, counters);

		return Arc.DEFAULT_ARC;
	}

	private Map<String, HostedByEntry> loadHostedByMap(final String datasourceId) throws DocumentException, DatabaseException {
		final Map<String, HostedByEntry> map = Maps.newHashMap();

		final String sql = "SELECT d.id, d.officialname, p.entry from %s p JOIN datasources d ON (p.datasourceid = d.id) WHERE p.oa_source_id= '%s'";

		final ResultSet<String> epr = this.serviceLocator.getService(DatabaseService.class).searchSQL(getDbName(),
				String.format(sql, getHostedbyMapTable(), datasourceId));

		final SAXReader reader = new SAXReader();
		for (final String s : this.resultSetClient.iter(epr, String.class)) {
			final Document doc = reader.read(new StringReader(s));
			final String entry = doc.valueOf("//FIELD[@name='entry']");
			final String dsId = doc.valueOf("//FIELD[@name='id']");
			final String dsName = doc.valueOf("//FIELD[@name='officialname']");
			map.put(entry, new HostedByEntry(dsId, dsName));
		}

		log.info(String.format("built hostedByMap from dsId '%s', size: '%s'", datasourceId, map.size()));

		return map;
	}

	/**
	 * Getter for property 'inputEprParam'.
	 *
	 * @return Value for property 'inputEprParam'.
	 */
	public String getInputEprParam() {
		return this.inputEprParam;
	}

	/**
	 * Setter for property 'inputEprParam'.
	 *
	 * @param inputEprParam
	 *            Value to set for property 'inputEprParam'.
	 */
	public void setInputEprParam(final String inputEprParam) {
		this.inputEprParam = inputEprParam;
	}

	/**
	 * Getter for property 'outputEprParam'.
	 *
	 * @return Value for property 'outputEprParam'.
	 */
	public String getOutputEprParam() {
		return this.outputEprParam;
	}

	/**
	 * Setter for property 'outputEprParam'.
	 *
	 * @param outputEprParam
	 *            Value to set for property 'outputEprParam'.
	 */
	public void setOutputEprParam(final String outputEprParam) {
		this.outputEprParam = outputEprParam;
	}

	/**
	 * Getter for property 'dbName'.
	 *
	 * @return Value for property 'dbName'.
	 */
	public String getDbName() {
		return this.dbName;
	}

	/**
	 * Setter for property 'dbName'.
	 *
	 * @param dbName
	 *            Value to set for property 'dbName'.
	 */
	public void setDbName(final String dbName) {
		this.dbName = dbName;
	}

	/**
	 * Getter for property 'countersParam'.
	 *
	 * @return Value for property 'countersParam'.
	 */
	public String getCountersParam() {
		return this.countersParam;
	}

	/**
	 * Setter for property 'countersParam'.
	 *
	 * @param countersParam
	 *            Value to set for property 'countersParam'.
	 */
	public void setCountersParam(final String countersParam) {
		this.countersParam = countersParam;
	}

	/**
	 * @return the hostedbyMapTable
	 */
	public String getHostedbyMapTable() {
		return this.hostedbyMapTable;
	}

	/**
	 * @param hostedbyMapTable
	 *            the hostedbyMapTable to set
	 */
	public void setHostedbyMapTable(final String hostedbyMapTable) {
		this.hostedbyMapTable = hostedbyMapTable;
	}

	public String getXpathEntry() {
		return this.xpathEntry;
	}

	public void setXpathEntry(final String xpathEntry) {
		this.xpathEntry = xpathEntry;
	}

	/**
	 * @return the overrideDataSourceId
	 */
	public String getOverrideDataSourceId() {
		return this.overrideDataSourceId;
	}

	/**
	 * @param overrideDataSourceId
	 *            the overrideDataSourceId to set
	 */
	public void setOverrideDataSourceId(final String overrideDataSourceId) {
		this.overrideDataSourceId = overrideDataSourceId;
	}
}
