package eu.dnetlib.msro.workflows.nodes.hostedby;

import org.antlr.stringtemplate.StringTemplate;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;

import eu.dnetlib.msro.workflows.graph.Arc;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;
import eu.dnetlib.msro.workflows.procs.Env;
import eu.dnetlib.msro.workflows.util.WorkflowsConstants;

/**
 * Created by alessia on 01/02/16.
 */
public class PrepareHostedbyUpdateSQL extends SimpleJobNode {

	private static final Log log = LogFactory.getLog(PrepareHostedbyUpdateSQL.class);
	private String updateSqlTemplatePath;
	private String theQueryParamName = "hostedByUpdateSQL";

	@Override
	protected String execute(final Env env) throws Exception {
		final String datasourceId = env.getAttribute(WorkflowsConstants.LOG_DATASOURCE_ID, String.class);
		final String datasourceNamespacePrefix = env.getAttribute(WorkflowsConstants.DATASOURCE_PREFIX, String.class);
		final Resource updateSqlTemplate = new ClassPathResource(this.updateSqlTemplatePath);
		final StringTemplate st = new StringTemplate(IOUtils.toString(updateSqlTemplate.getInputStream()));
		st.setAttribute("datasourceId", datasourceId);
		st.setAttribute("datasourceNamespacePrefix", datasourceNamespacePrefix);
		final String theQuery = st.toString();
		log.debug("Generated query: " + theQuery);
		env.setAttribute(this.theQueryParamName, theQuery);
		return Arc.DEFAULT_ARC;
	}

	public String getUpdateSqlTemplatePath() {
		return this.updateSqlTemplatePath;
	}

	public void setUpdateSqlTemplatePath(final String updateSqlTemplatePath) {
		this.updateSqlTemplatePath = updateSqlTemplatePath;
	}

	public String getTheQueryParamName() {
		return this.theQueryParamName;
	}

	public void setTheQueryParamName(final String theQueryParamName) {
		this.theQueryParamName = theQueryParamName;
	}
}
