package eu.dnetlib.msro.workflows.nodes.objectstore;

import java.io.File;
import java.util.List;

import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.springframework.beans.factory.annotation.Autowired;

import eu.dnetlib.enabling.resultset.client.ResultSetClient;
import eu.dnetlib.enabling.resultset.factory.ResultSetFactory;
import eu.dnetlib.enabling.tools.blackboard.BlackboardJob;
import eu.dnetlib.msro.workflows.nodes.BlackboardJobNode;
import eu.dnetlib.msro.workflows.procs.Env;
import eu.dnetlib.msro.workflows.procs.Token;
import eu.dnetlib.msro.workflows.util.ResultsetProgressProvider;
import eu.dnetlib.rmi.common.ResultSet;
import eu.dnetlib.rmi.data.ObjectStoreService;
import eu.dnetlib.rmi.data.Protocols;

public class ImportFilesJobNode extends BlackboardJobNode {

	private String basePath;
	private String repositoryPrefix;
	private String oaiPrefix;
	private String objectStoreId;
	private String contentDescription;

	@Autowired
	private ResultSetFactory resultSetFactory;

	@Autowired
	private ResultSetClient resultSetClient;

	public String getRepositoryPrefix() {
		return this.repositoryPrefix;
	}

	public void setRepositoryPrefix(final String repositoryPrefix) {
		this.repositoryPrefix = repositoryPrefix;
	}

	public String getBasePath() {
		return this.basePath;
	}

	public void setBasePath(final String basePath) {
		this.basePath = basePath;
	}

	@Override
	protected String obtainServiceId(final Env env) {
		return getServiceLocator().getServiceId(ObjectStoreService.class);
	}

	@Override
	protected void prepareJob(final BlackboardJob job, final Token token) throws Exception {
		final File dir = new File(this.basePath);

		System.out.println("Getting all files in " + dir.getCanonicalPath() + " including those in subdirectories");
		final List<File> files = (List<File>) FileUtils.listFiles(dir, TrueFileFilter.INSTANCE, TrueFileFilter.INSTANCE);
		IteratorRepository irepo;
		if (this.repositoryPrefix.equals("od________18")) {
			irepo = new ArxivIteratorRepository(files, this.repositoryPrefix, this.oaiPrefix);
		} else if (this.repositoryPrefix.equals("od______2367")) {
			irepo = new PUMAIteratorRepository(files, this.repositoryPrefix, this.oaiPrefix);
		} else {
			irepo = new RepositoryNoURLIterator(files, this.repositoryPrefix, this.oaiPrefix);
		}
		final ResultSet<String> epr = this.resultSetFactory.createResultSet(irepo);

		token.setProgressProvider(new ResultsetProgressProvider(epr, this.resultSetClient));

		job.setAction("FEED");
		job.getParameters().put("obsID", getObjectStoreId());
		job.getParameters().put("mime", getContentDescription());
		job.getParameters().put("protocol", Protocols.File_System.toString());
		job.getParameters().put("epr", epr.toJson());
	}

	public String getObjectStoreId() {
		return this.objectStoreId;
	}

	public void setObjectStoreId(final String objectStoreId) {
		this.objectStoreId = objectStoreId;
	}

	public String getContentDescription() {
		return this.contentDescription;
	}

	public void setContentDescription(final String contentDescription) {
		this.contentDescription = contentDescription;
	}

	public String getOaiPrefix() {
		return this.oaiPrefix;
	}

	public void setOaiPrefix(final String oaiPrefix) {
		this.oaiPrefix = oaiPrefix;
	}
}
