package eu.dnetlib.msro.workflows.nodes.provision;

import java.util.List;
import javax.annotation.Resource;

import com.google.common.collect.Iterables;
import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;
import eu.dnetlib.msro.workflows.procs.Env;
import eu.dnetlib.rmi.enabling.ISLookUpService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FindIndexJobNode extends SimpleJobNode {

	/**
	 * logger.
	 */
	private static final Log log = LogFactory.getLog(FindIndexJobNode.class); // NOPMD by marko on 11/24/08 5:02 PM

	@Resource
	private UniqueServiceLocator serviceLocator;

	/**
	 * if non null, overrides format from env.
	 */
	private String mdFormat;

	/**
	 * if non null, overrides format from env.
	 */
	private String layout;

	/**
	 * if non null, overrides format from env.
	 */
	private String interpretation;

	/**
	 * {@inheritDoc}
	 *
	 */
	@Override
	public String execute(final Env env) {
		final String envFormat = env.getAttribute("format", String.class);
		final String envLayout = env.getAttribute("layout", String.class);
		final String envInterpretation = env.getAttribute("interpretation", String.class);

		final String format = handleOverride(env, "format", envFormat, getMdFormat());
		final String layout = handleOverride(env, "layout", envLayout, getLayout());
		final String interp = handleOverride(env, "interpretation", envInterpretation, getInterpretation());

		String mdRef = format + "-" + layout + "-" + interp;
		log.info("searching index for [" + mdRef + "]");

		final String indexId = findIndex(format, layout, interp);
		env.setAttribute("index_id", indexId);

		if (indexId == null || indexId.isEmpty()) {
			log.info("no index was found for [" + mdRef + "]");
			return "notFound";
		} else {
			log.info("index found for [" + mdRef + "]: " + indexId);
			return "found";
		}
	}

	private String findIndex(final String format, final String layout, final String interp) {
		final String xquery =
				"for $x in /RESOURCE_PROFILE[.//RESOURCE_TYPE/@value='IndexDSResourceType']" + "return $x[.//METADATA_FORMAT = '" + format
						+ "' and .//METADATA_FORMAT_LAYOUT='" + layout + "' and .//METADATA_FORMAT_INTERPRETATION = '" + interp
						+ "']//RESOURCE_IDENTIFIER/@value/string()";
		try {
			log.info("xquery: " + xquery);
			List<String> ids = serviceLocator.getService(ISLookUpService.class).quickSearchProfile(xquery);
			log.info("found indexDS ids: " + ids);
			if (ids == null || ids.isEmpty()) { return null; }
			if (ids.size() > 1) { throw new IllegalStateException("found more than one index of given format: " + format + ", layout: " + layout
					+ ", interpretation: " + interp); }
			return Iterables.getOnlyElement(ids);
		} catch (Exception e) {
			return null;
		}
	}

	private String handleOverride(final Env env, final String name, final String envParam, final String override) {
		if (override != null) {
			env.setAttribute(name, override);
		}
		return override != null ? override : envParam;
	}

	public String getMdFormat() {
		return mdFormat;
	}

	public void setMdFormat(final String mdFormat) {
		this.mdFormat = mdFormat;
	}

	public String getLayout() {
		return layout;
	}

	public void setLayout(final String layout) {
		this.layout = layout;
	}

	public String getInterpretation() {
		return interpretation;
	}

	public void setInterpretation(final String interpretation) {
		this.interpretation = interpretation;
	}

}
