package eu.dnetlib.msro.workflows.nodes.repohi;

import java.io.StringReader;

import javax.annotation.Resource;

import org.dom4j.Document;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;

import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.msro.workflows.graph.Arc;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;
import eu.dnetlib.msro.workflows.procs.Env;
import eu.dnetlib.msro.workflows.util.WorkflowsConstants;
import eu.dnetlib.rmi.enabling.ISLookUpService;

public class RetrieveInterfaceInfoJobNode extends SimpleJobNode {

	@Resource
	private UniqueServiceLocator serviceLocator;

	@Override
	protected String execute(final Env env) throws Exception {

		final String datasourceId = env.getAttribute(WorkflowsConstants.LOG_DATASOURCE_ID, String.class);
		final String interfaceID = env.getAttribute(WorkflowsConstants.LOG_DATASOURCE_INTERFACE, String.class);
		final String profile = this.serviceLocator.getService(ISLookUpService.class).getResourceProfile(datasourceId);
		final Document doc = new SAXReader().read(new StringReader(profile));
		final Node ifcNode = doc.selectSingleNode("//INTERFACE[@id='" + interfaceID + "']");

		final String contentDescription = ifcNode.valueOf("./@contentDescription");
		env.setAttribute("objectStoreContentDescription", contentDescription);

		final Node acProtNode = doc.selectSingleNode("//INTERFACE[@id='" + interfaceID + "']/ACCESS_PROTOCOL");

		final String basePath = acProtNode.valueOf("./@basePath");
		env.setAttribute("objectStoreBasePath", basePath);

		return Arc.DEFAULT_ARC;
	}

}
