package eu.dnetlib.msro.workflows.profiles;

/**
 * Created by claudio on 14/06/16.
 */
import java.io.IOException;
import java.io.StringWriter;
import java.util.List;
import java.util.Map;

import org.antlr.stringtemplate.StringTemplate;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;

import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;

public class RepositoryXsltFunctions {

	private static final Log log = LogFactory.getLog(RepositoryXsltFunctions.class); // NOPMD by marko on 11/24/08 5:02 PM

	private static Resource ifaceTemplate = new ClassPathResource("/eu/dnetlib/msro/openaireplus/workflows/profiles/repo_interface.st");

	private static Resource paramTemplate = new ClassPathResource("/eu/dnetlib/msro/openaireplus/workflows/profiles/repo_param.st");

	private enum Params {
		FORMAT, SET
	};

	public static String buildInterface(final String infopackage) {

		final List<String> formats = Lists.newArrayList();
		final List<String> sets = Lists.newArrayList();
		final Map<String, String> otherParams = Maps.newHashMap();

		for (String param : parseParams(getValueBetween(infopackage, "===6===", null))) {
			StringTemplate p = getTemplate(paramTemplate);
			String paramName = StringUtils.substringBefore(param, "=").trim();
			String paramValue = StringUtils.substringAfter(param, "=").trim();

			p.setAttribute("param", paramName.toUpperCase());
			p.setAttribute("value", paramValue);

			try {
				switch (Params.valueOf(paramName.toUpperCase())) {
				case FORMAT:
					formats.add(p.toString());
					break;
				case SET:
					sets.add(p.toString());
					break;
				}
			} catch (Exception e) {
				if ((paramName != null) && !paramName.isEmpty()) {
					otherParams.put(paramName, StringEscapeUtils.escapeXml(paramValue));
				}
			}
		}

		final StringTemplate i = getTemplate(ifaceTemplate);
		i.setAttribute("id", getValueBetween(infopackage, null, "===1==="));
		i.setAttribute("fileMode", getValueBetween(infopackage, "===1===", "===2==="));
		i.setAttribute("fileDesc", getValueBetween(infopackage, "===2===", "===3==="));
		i.setAttribute("iisWf", getValueBetween(infopackage, "===3===", "===4==="));
		i.setAttribute("baseUrl", getBaseUrl(getValueBetween(infopackage, "===4===", "===5===")));
		i.setAttribute("accessProtocol", getAccessProtocol(getValueBetween(infopackage, "===5===", "===6==="), otherParams));
		i.setAttribute("formats", ensureMinOccurs(formats, "<FORMAT/>"));
		i.setAttribute("sets", ensureMinOccurs(sets, "<SET/>"));
		if (!otherParams.isEmpty()) {
			i.setAttribute("otherParams", otherParams);
		}

		final String iface = i.toString();
		return iface;
	}

	private static String getValueBetween(final String s, final String pre, final String post) {
		if ((pre == null) && (post == null)) {
			return s;
		} else if (pre == null) {
			return StringUtils.substringBefore(s, post);
		} else if (post == null) {
			return StringUtils.substringAfter(s, pre);
		} else {
			return StringUtils.substringBetween(s, pre, post);
		}
	}

	private static List<String> ensureMinOccurs(final List<String> list, final String empty) {
		if (list.isEmpty()) {
			list.add(empty);
		}
		return list;
	}

	private static Iterable<String> parseParams(final String s) {
		return Splitter.on("***").omitEmptyStrings().trimResults().split(s);
	}

	private static String getBaseUrl(final String url) {
		final StringTemplate b = getTemplate(paramTemplate);
		b.setAttribute("param", "BASE_URL");
		b.setAttribute("value", url);
		return b.toString();
	}

	private static String getAccessProtocol(final String protocol, final Map<String, String> otherParams) {
		final StringTemplate a = getTemplate(paramTemplate);
		a.setAttribute("param", "ACCESS_PROTOCOL");
		a.setAttribute("value", protocol);
		if ((otherParams != null) && !otherParams.isEmpty()) {
			a.setAttribute("attrs", otherParams);
		}
		return a.toString();
	}

	private static StringTemplate getTemplate(final Resource res) {
		final StringWriter body = new StringWriter();
		try {
			IOUtils.copy(res.getInputStream(), body);
			return new StringTemplate(body.toString());
		} catch (IOException e) {
			log.error("unable to get template", e);
			throw new RuntimeException(e);
		}
	}

}
