package eu.dnetlib.msro.workflows.nodes;

import java.util.List;

import javax.annotation.Resource;

import eu.dnetlib.msro.workflows.graph.Arc;
import eu.dnetlib.msro.workflows.procs.Env;
import eu.dnetlib.rmi.enabling.ISLookUpException;
import eu.dnetlib.rmi.enabling.ISLookUpService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.google.gson.Gson;

import eu.dnetlib.enabling.locators.UniqueServiceLocator;

public class FetchRelClassesJobNode extends SimpleJobNode {

	private static final Log log = LogFactory.getLog(FetchRelClassesJobNode.class); // NOPMD by marko on 11/24/08 5:02 PM

	private String xquery;

	private String relClassesName;

	@Resource
	private UniqueServiceLocator serviceLocator;

	@Override
	protected String execute(final Env env) throws Exception {

		final String relClasses = new Gson().toJson(fetchRelClasses());

		log.info("loaded relClasses: " + relClasses);

		env.setAttribute(getRelClassesName(), relClasses);

		return Arc.DEFAULT_ARC;
	}

	private List<String> fetchRelClasses() throws ISLookUpException {

		log.info("Loading relClasses with xquery: " + getXquery());

		return serviceLocator.getService(ISLookUpService.class).quickSearchProfile(getXquery());
	}

	public String getRelClassesName() {
		return relClassesName;
	}

	public void setRelClassesName(final String relClassesName) {
		this.relClassesName = relClassesName;
	}

	public String getXquery() {
		return xquery;
	}

	public void setXquery(final String xquery) {
		this.xquery = xquery;
	}
}
