package eu.dnetlib.msro.workflows.nodes;

import java.util.List;

import org.apache.commons.io.IOUtils;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.core.io.Resource;

import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.msro.workflows.graph.Arc;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;
import eu.dnetlib.msro.workflows.procs.Env;
import eu.dnetlib.rmi.enabling.ISLookUpService;

public class FindVocabularyEntriesJobNode extends SimpleJobNode {

	private String outputEprParam = "epr";

	@javax.annotation.Resource
	private UniqueServiceLocator serviceLocator;

	private Resource xquery;

	@Override
	protected String execute(final Env env) throws Exception {
		final String query = IOUtils.toString(this.xquery.getInputStream());
		final List<String> epr = this.serviceLocator.getService(ISLookUpService.class).quickSearchProfile(query);
		env.setAttribute(getOutputEprParam(), epr);

		return Arc.DEFAULT_ARC;
	}

	public String getOutputEprParam() {
		return this.outputEprParam;
	}

	public void setOutputEprParam(final String outputEprParam) {
		this.outputEprParam = outputEprParam;
	}

	public Resource getXquery() {
		return this.xquery;
	}

	@Required
	public void setXquery(final Resource xquery) {
		this.xquery = xquery;
	}

}
