package eu.dnetlib.msro.workflows.nodes;

import javax.annotation.Resource;

import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.msro.workflows.graph.Arc;
import eu.dnetlib.msro.workflows.procs.Env;
import eu.dnetlib.rmi.enabling.ISRegistryException;
import eu.dnetlib.rmi.enabling.ISRegistryService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class IndexDSUpdateJobNode extends SimpleJobNode {

	private static final Log log = LogFactory.getLog(IndexDSUpdateJobNode.class); // NOPMD by marko on 11/24/08 5:02 PM

	public final static String N_RECORDS_PARAM = "blackboard:param:index.status code: 0";

	@Resource
	private UniqueServiceLocator serviceLocator;

	@Override
	public String execute(final Env env) throws Exception {

		final String dsId = env.getAttribute("index_id", String.class);
		final String version = env.getAttribute("index.feed.timestamp", String.class);

		try {
			final int count = Integer.parseInt(env.getAttribute(N_RECORDS_PARAM, String.class));
			log.info("updating indexDS: " + dsId + " version: " + version + " record count: " + count);
			updateIndexDS(dsId, version, count);
		} catch (NumberFormatException e) {
			log.warn("unable to find index feeding details in the workflow env, skippind DS update");
		}

		return Arc.DEFAULT_ARC;
	}

	/**
	 * method updates the given indexDataStructureId INDEX_SIZE, INDEX_LAST_UPDATE
	 * 
	 * @param dsId
	 * @param version
	 * @param count
	 * @return true if the update was performed successfully, false otherwise
	 * @throws ISRegistryException
	 */
	private boolean updateIndexDS(final String dsId, final String version, final long count) throws ISRegistryException {

		final String xquery = "for $x in collection('')/RESOURCE_PROFILE[.//RESOURCE_IDENTIFIER/@value = '" + dsId + "']"
				+ " return update value $x//INDEX_SIZE with " + String.valueOf(count) + ","
				+ "for $x in collection('')/RESOURCE_PROFILE[.//RESOURCE_IDENTIFIER/@value = '" + dsId + "']"
				+ " return update value $x//INDEX_LAST_UPDATE with '" + version + "' ";

		log.debug("\n\n updating indexDataStructure: " + xquery + "\n\n");

		return serviceLocator.getService(ISRegistryService.class).executeXUpdate(xquery);
	}

}
