package eu.dnetlib.msro.workflows.nodes;

import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;

import eu.dnetlib.msro.workflows.graph.Arc;
import eu.dnetlib.msro.workflows.nodes.index.ContextLoader;
import eu.dnetlib.msro.workflows.procs.Env;
import eu.dnetlib.rmi.manager.MSROException;

public class LoadContextsJobNode extends SimpleJobNode {

	/**
	 * logger.
	 */
	private static final Log log = LogFactory.getLog(LoadContextsJobNode.class); // NOPMD by marko on 11/24/08 5:02 PM

	private String contextParam;

	@Autowired
	private ContextLoader contextLoader;

	@Override
	protected String execute(final Env env) throws Exception {

		log.info("start preparing job");

		final String contexts = this.contextLoader.load();

		if (StringUtils.isBlank(contexts)) { throw new MSROException("empty contexts"); }

		env.setAttribute(getContextParam(), contexts);

		return Arc.DEFAULT_ARC;
	}

	public String getContextParam() {
		return contextParam;
	}

	public void setContextParam(final String contextParam) {
		this.contextParam = contextParam;
	}
}
