package eu.dnetlib.msro.workflows.nodes;

import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;

import eu.dnetlib.msro.workflows.graph.Arc;
import eu.dnetlib.msro.workflows.nodes.index.EntityGrouperConfigurationLoader;
import eu.dnetlib.msro.workflows.procs.Env;
import eu.dnetlib.rmi.manager.MSROException;

public class LoadEntityLinksJobNode extends SimpleJobNode {

	/**
	 * logger.
	 */
	private static final Log log = LogFactory.getLog(LoadEntityLinksJobNode.class); // NOPMD by marko on 11/24/08 5:02 PM

	private String entityLinksParam;

	@Autowired
	private EntityGrouperConfigurationLoader grouperConfLoader;

	@Override
	protected String execute(final Env env) throws Exception {

		log.info("loading entity link table");

		final String links = this.grouperConfLoader.load();

		if (StringUtils.isBlank(links)) { throw new MSROException("empty links table"); }

		env.setAttribute(getEntityLinksParam(), links);

		return Arc.DEFAULT_ARC;
	}

	public String getEntityLinksParam() {
		return entityLinksParam;
	}

	public void setEntityLinksParam(final String entityLinksParam) {
		this.entityLinksParam = entityLinksParam;
	}
}
