package eu.dnetlib.msro.workflows.nodes;

import javax.annotation.Resource;

import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.miscutils.datetime.DateUtils;
import eu.dnetlib.msro.workflows.graph.Arc;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;
import eu.dnetlib.msro.workflows.procs.Env;
import eu.dnetlib.msro.workflows.util.WorkflowsConstants;
import eu.dnetlib.rmi.enabling.ISLookUpService;

public class ObtainOpenaireDataSourceParamsJobNode extends SimpleJobNode {

	private String providerId;

	@Resource
	private UniqueServiceLocator serviceLocator;

	@Override
	protected String execute(final Env env) throws Exception {
		final String query = "let $x := /*[.//RESOURCE_IDENTIFIER/@value='" + this.providerId + "']//EXTRA_FIELDS\n"
				+ "return concat($x/FIELD[./key='OpenAireDataSourceId']/value, ' @@@ ', $x/FIELD[./key='NamespacePrefix']/value)";

		final String[] arr = this.serviceLocator.getService(ISLookUpService.class).getResourceProfileByQuery(query).split("@@@");

		final String origId = arr[0].trim();
		final String nsPrefix = arr[1].trim();
		// this is needed by the mdbuilder
		// TODO: update mdbuilder to use the env attributes below, whose names are defined in WorkflowConstants
		env.setAttribute("parentDatasourceId", origId);
		env.setAttribute("namespacePrefix", nsPrefix);
		env.setAttribute("dateOfCollection", DateUtils.now_ISO8601());

		// these are needed for validation and fill hostedby
		env.setAttribute(WorkflowsConstants.LOG_DATASOURCE_ID, origId);
		env.setAttribute(WorkflowsConstants.DATASOURCE_PREFIX, nsPrefix);

		return Arc.DEFAULT_ARC;

	}

	public String getProviderId() {
		return this.providerId;
	}

	public void setProviderId(final String providerId) {
		this.providerId = providerId;
	}

}
