package eu.dnetlib.msro.workflows.nodes.actionmanager;

import java.util.List;
import java.util.Map;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;

import com.google.common.base.Predicate;
import com.google.common.collect.Maps;
import com.google.gson.Gson;

import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.miscutils.datetime.DateUtils;
import eu.dnetlib.msro.workflows.graph.Arc;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;
import eu.dnetlib.msro.workflows.procs.Env;
import eu.dnetlib.rmi.data.hadoop.actionmanager.RawSet;
import eu.dnetlib.rmi.enabling.ISLookUpService;

public class PrepareActionSetsJobNode extends SimpleJobNode {

	/**
	 * logger.
	 */
	private static final Log log = LogFactory.getLog(PrepareActionSetsJobNode.class);

	@Autowired
	private UniqueServiceLocator serviceLocator;

	private String sets;

	@Override
	protected String execute(final Env env) throws Exception {

		final List<Map<String, String>> setList = getSetList();
		final String now = DateUtils.now_ISO8601();

		final String basePath = this.serviceLocator.getService(ISLookUpService.class).getResourceProfileByQuery(
				"/RESOURCE_PROFILE[./HEADER/RESOURCE_TYPE/@value='ActionManagerServiceResourceType']//SERVICE_PROPERTIES/PROPERTY[@key='basePath']/@value/string()");

		for (final Map<String, String> set : setList) {

			set.put("rawset", RawSet.newInstance().getId());
			set.put("creationDate", now);
			set.put("path", getPath(basePath, set));

			if (set.get("enabled").equals("true")) {
				log.info("preparing set: " + simplifySetInfo(set));
			}
			// setting the job properties needed to name the rawsets
			env.setAttribute(set.get("jobProperty"), set.get("rawset"));
		}

		env.setAttribute("sets", new Gson().toJson(setList));
		env.setAttribute("actionManagerBasePath", basePath);

		return Arc.DEFAULT_ARC;
	}

	private String getPath(final String basePath, final Map<String, String> set) {
		final StringBuilder sb = new StringBuilder();
		sb.append(basePath).append("/").append(set.get("set")).append("/").append(set.get("rawset"));
		final String path = sb.toString();
		log.debug("path: " + path);
		return path;
	}

	private Map<String, String> simplifySetInfo(final Map<String, String> set) {
		return Maps.filterKeys(set, new Predicate<String>() {

			@Override
			public boolean apply(final String k) {

				return k.equals("set") || k.equals("rawset");
			}
		});
	}

	@SuppressWarnings("unchecked")
	protected List<Map<String, String>> getSetList() {
		return new Gson().fromJson(getSets(), List.class);
	}

	public String getSets() {
		return this.sets;
	}

	public void setSets(final String sets) {
		this.sets = sets;
	}

}
