package eu.dnetlib.msro.workflows.nodes.claims;

import java.io.StringReader;
import java.util.function.UnaryOperator;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.QName;
import org.dom4j.io.SAXReader;
import org.springframework.beans.factory.annotation.Autowired;

import eu.dnetlib.enabling.resultset.factory.ResultSetFactory;
import eu.dnetlib.msro.workflows.graph.Arc;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;
import eu.dnetlib.msro.workflows.nodes.hadoop.SetHdfsFileJobNode;
import eu.dnetlib.msro.workflows.procs.Env;
import eu.dnetlib.rmi.common.ResultSet;

public class DecapsuleClaimsJobNode extends SimpleJobNode {

	/**
	 * logger.
	 */
	private static final Log log = LogFactory.getLog(SetHdfsFileJobNode.class);

	private static final Namespace OAF_NS = new Namespace("oaf", "http://namespace.openaire.eu/oaf");
	private static final double DEFAULT_TRUST = 0.9;

	private String inputEprParam;
	private String outputEprParam;

	@Autowired
	private ResultSetFactory resultSetFactory;

	@Override
	protected String execute(final Env env) throws Exception {
		final SAXReader reader = new SAXReader();

		final UnaryOperator<String> mapper = row -> {
			try {
				final Document docRow = reader.read(new StringReader(row));

				final String xml = docRow.valueOf("//ROW/FIELD[@name = 'xml']");
				final String provenance = docRow.valueOf("//ROW/FIELD[@name = 'provenance']");

				final Document doc = reader.read(new StringReader(xml));
				final Element record = (Element) doc.selectSingleNode("//*[local-name() = 'record']");
				final Element about = record.addElement(new QName("about"));
				final Element dataInfo = about.addElement(new QName("datainfo", OAF_NS));

				dataInfo.addElement(new QName("inferred", OAF_NS)).setText("false");
				dataInfo.addElement(new QName("deletedbyinference", OAF_NS)).setText("false");
				dataInfo.addElement(new QName("trust", OAF_NS)).setText(Double.toString(DEFAULT_TRUST));
				dataInfo.addElement(new QName("inferenceprovenance", OAF_NS)).setText("");

				final Element action = dataInfo.addElement(new QName("provenanceaction", OAF_NS));
				action.addAttribute("schemename", "dnet:provenanceActions");
				action.addAttribute("schemeid", "dnet:provenanceActions");
				action.addAttribute("classname", provenance);
				action.addAttribute("classid", provenance);

				return doc.asXML();
			} catch (final Throwable e) {
				log.error("Error parsing row: " + row, e);
				throw new IllegalArgumentException("Error parsing row: " + row, e);
			}
		};

		final ResultSet<?> inputEpr = env.getAttribute(getInputEprParam(), ResultSet.class);
		final ResultSet<String> epr = this.resultSetFactory.map(inputEpr, String.class, mapper);

		env.setAttribute(getOutputEprParam(), epr);

		return Arc.DEFAULT_ARC;
	}

	public String getInputEprParam() {
		return this.inputEprParam;
	}

	public void setInputEprParam(final String inputEprParam) {
		this.inputEprParam = inputEprParam;
	}

	public String getOutputEprParam() {
		return this.outputEprParam;
	}

	public void setOutputEprParam(final String outputEprParam) {
		this.outputEprParam = outputEprParam;
	}

}
