package eu.dnetlib.msro.workflows.nodes.dedup;

import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;
import eu.dnetlib.msro.workflows.nodes.dedup.utils.DedupConfigurationOrchestration;
import eu.dnetlib.msro.workflows.nodes.dedup.utils.DedupConfigurationOrchestrationLoader;
import eu.dnetlib.msro.workflows.procs.Env;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;

/**
 * Created by claudio on 13/07/16.
 */
public class SelectWfPathByDedupEntityJobNode extends SimpleJobNode {

	private static final Log log = LogFactory.getLog(SelectWfPathByDedupEntityJobNode.class);

	@Autowired
	private DedupConfigurationOrchestrationLoader dedupOrchestrationLoader;

	private String dedupConfigSequence;

	@Override
	protected String execute(final Env env) throws Exception {

		if (StringUtils.isBlank(getDedupConfigSequence())) throw new IllegalArgumentException("missing configuration sequence");

		final DedupConfigurationOrchestration dedupOrchestration = dedupOrchestrationLoader.loadByActionSetId(getDedupConfigSequence());

		final String entityName = dedupOrchestration.getEntity().getName();

		log.info("following workflow path: " + entityName);

		return entityName;
	}

	public String getDedupConfigSequence() {
		return dedupConfigSequence;
	}

	public void setDedupConfigSequence(final String dedupConfigSequence) {
		this.dedupConfigSequence = dedupConfigSequence;
	}


}
