package eu.dnetlib.msro.workflows.nodes.dfm;

import java.io.IOException;

import javax.annotation.Resource;

import eu.dnetlib.monitoring.core.sensors.SensorCreationException;
import eu.dnetlib.monitoring.core.sensors.SensorFactory;
import eu.dnetlib.monitoring.core.sensors.collection.SensorWrapper;
import eu.dnetlib.monitoring.core.sensors.collection.index.solr.SolrSensor;
import eu.dnetlib.monitoring.core.sensors.collection.kv.redis.RedisSensor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.msro.workflows.graph.Arc;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;
import eu.dnetlib.msro.workflows.procs.Env;
import eu.dnetlib.rmi.enabling.ISLookUpException;

public class TriggerPrepublicMonitoringScenarioJobNode extends SimpleJobNode {

	private final Log log = LogFactory.getLog(TriggerPrepublicMonitoringScenarioJobNode.class);

	private final static String SOLR_COLLECTION_POSTFIX = "-index-openaire";
	private String mdFormat;

	@Resource
	private UniqueServiceLocator serviceLocator;

	private SolrSensor solrSensor;
	private RedisSensor redisSensor;
	private SensorWrapper wrapper;

	@Override
	protected String execute(final Env env) throws IOException, InstantiationException, IllegalAccessException, InterruptedException,
			ISLookUpException, SensorCreationException {
		this.log.info("Execution of TriggerPrepublicMonitoringScenarioJobNode");

		/* Configuring SOLR sensor */
		final String actualCollection = this.mdFormat + SOLR_COLLECTION_POSTFIX;
		this.log.info("At this round, the Pre-public monitoring scenario will check against " + actualCollection + " SOLR collection");
		this.solrSensor = (SolrSensor) SensorFactory.createSensorWithConfiguration(SolrSensor.class, "prepublic", "solr");
		this.solrSensor.getConfiguration().setParam("collection", actualCollection);
		this.solrSensor.reinitialize();

		/* Configuring Redis sensor */
		this.redisSensor = (RedisSensor) SensorFactory.createSensorWithConfiguration(RedisSensor.class, "prepublic", "redis");

		/* Wrapping the two sensors together */
		this.wrapper = (SensorWrapper) SensorFactory.createSensor(SensorWrapper.class);
		this.wrapper.registerSensor(this.solrSensor);
		this.wrapper.registerSensor(this.redisSensor);

		this.log.info("Measuring prepublic scenario");
		this.wrapper.measure();
		this.log.info("DONE!");
		return Arc.DEFAULT_ARC;
	}

	public String getMdFormat() {
		return this.mdFormat;
	}

	public void setMdFormat(final String mdFormat) {
		this.mdFormat = mdFormat;
	}

}
