package eu.dnetlib.msro.workflows.nodes.hadoop;

import java.util.List;
import java.util.Map;

import org.springframework.beans.factory.annotation.Required;

import com.google.gson.Gson;

import eu.dnetlib.msro.workflows.graph.Arc;
import eu.dnetlib.msro.workflows.procs.Env;

public class PrepareIISMainParamsJobNode extends PrepareIISParams {

	private String xqueryObjectStores;

	private String objectStoreParam = "import_content_objectstores_csv";

	// Enable/Disable inference modules

	@Override
	protected String execute(final Env env) throws Exception {

		super.prepare(env);

		env.setAttribute(getObjectStoreParam(), getFilteredObjectStoreCSV(getXqueryObjectStores()));

		@SuppressWarnings("unchecked")
		final List<Map<String, String>> sets = new Gson().fromJson(env.getAttribute("sets", String.class), List.class);
		for (final Map<String, String> set : sets) {
			env.setAttribute(set.get("enablingProperty"), set.get("enabled"));
		}

		return Arc.DEFAULT_ARC;
	}

	public String getXqueryObjectStores() {
		return this.xqueryObjectStores;
	}

	@Required
	public void setXqueryObjectStores(final String xqueryObjectStores) {
		this.xqueryObjectStores = xqueryObjectStores;
	}

	public String getObjectStoreParam() {
		return this.objectStoreParam;
	}

	public void setObjectStoreParam(final String objectStoreParam) {
		this.objectStoreParam = objectStoreParam;
	}

}
