package eu.dnetlib.msro.workflows.nodes.hostedby;

import java.io.StringReader;
import java.util.function.UnaryOperator;

import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.springframework.beans.factory.annotation.Autowired;

import eu.dnetlib.enabling.resultset.factory.ResultSetFactory;
import eu.dnetlib.msro.workflows.graph.Arc;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;
import eu.dnetlib.msro.workflows.procs.Env;
import eu.dnetlib.rmi.common.ResultSet;

// TODO: Auto-generated Javadoc
/**
 * The Class FindHostedByJonbNode.
 */
public class FindHostedByJobNode extends SimpleJobNode {

	/** The input epr param. */
	private String inputEprParam;

	/** The output epr param. */
	private String outputEprParam;

	/** The counters param. */
	private String countersParam;

	/** The mapped result set factory. */
	@Autowired
	private ResultSetFactory resultSetFactory;

	private final String unknown_repo_id = "openaire____::1256f046-bf1f-4afc-8b47-d0b147148b18";

	/*
	 * (non-Javadoc)
	 *
	 * @see eu.dnetlib.msro.workflows.nodes.SimpleJobNode#execute(com.googlecode.sarasvati.NodeToken)
	 */
	@Override
	protected String execute(final Env env) throws Exception {
		final ResultSet<?> inputEpr = env.getAttribute(this.inputEprParam, ResultSet.class);
		final HostedByCounters counters = new HostedByCounters();

		final SAXReader reader = new SAXReader();

		final UnaryOperator<String> hostedByMapFunction = input -> {
			try {
				final Document doc = reader.read(new StringReader(input));
				final Element node = (Element) doc.selectSingleNode("//*[local-name()='hostedBy']");
				if (node != null) {
					final String hostedById = node.attributeValue("id");
					if (!hostedById.equals(FindHostedByJobNode.this.unknown_repo_id)) {
						counters.increaseCounter(hostedById);
					}
				}
			} catch (final Exception e) {

			}

			return input;
		};

		final ResultSet<String> epr = this.resultSetFactory.map(inputEpr, String.class,
				hostedByMapFunction);

		env.setAttribute(this.outputEprParam, epr);
		env.setAttribute(getCountersParam(), counters);

		return Arc.DEFAULT_ARC;
	}

	/**
	 * @return the inputEprParam
	 */
	public String getInputEprParam() {
		return this.inputEprParam;
	}

	/**
	 * @param inputEprParam
	 *            the inputEprParam to set
	 */
	public void setInputEprParam(final String inputEprParam) {
		this.inputEprParam = inputEprParam;
	}

	/**
	 * @return the outputEprParam
	 */
	public String getOutputEprParam() {
		return this.outputEprParam;
	}

	/**
	 * @param outputEprParam
	 *            the outputEprParam to set
	 */
	public void setOutputEprParam(final String outputEprParam) {
		this.outputEprParam = outputEprParam;
	}

	/**
	 * @return the countersParam
	 */
	public String getCountersParam() {
		return this.countersParam;
	}

	/**
	 * @param countersParam
	 *            the countersParam to set
	 */
	public void setCountersParam(final String countersParam) {
		this.countersParam = countersParam;
	}

}
