package eu.dnetlib.msro.workflows.nodes.objectstore;

import java.util.Map;

import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;

import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.enabling.tools.blackboard.BlackboardJob;
import eu.dnetlib.msro.workflows.nodes.blackboard.BlackboardWorkflowJobListener;
import eu.dnetlib.msro.workflows.nodes.download.DownloadFromMetadataJobNode;
import eu.dnetlib.msro.workflows.procs.Env;
import eu.dnetlib.msro.workflows.procs.Token;
import eu.dnetlib.msro.workflows.util.WorkflowsConstants;
import eu.dnetlib.rmi.data.ObjectStoreService;

public class DownloadFromMetadataOpenaire extends DownloadFromMetadataJobNode {

	private static final Log log = LogFactory.getLog(DownloadFromMetadataOpenaire.class);

	private String basepath;

	@Autowired
	private UniqueServiceLocator serviceLocator;

	@Override
	protected void prepareJob(final BlackboardJob job, final Token token) throws Exception {
		if (this.getBasepath() != null && this.getBasepath().length() > 0) {
			job.getParameters().put("basePath", this.basepath);
		}

		final int size = this.serviceLocator.getService(ObjectStoreService.class).getSize(getObjectStoreID());
		log.debug(String.format("objectStore %s has size %s", getObjectStoreID(), size));
		token.getEnv().setAttribute(WorkflowsConstants.MAIN_LOG_PREFIX + "oldTotal", size);

		super.prepareJob(job, token);
	}

	/*
	 * (non-Javadoc)
	 *
	 * @see eu.dnetlib.msro.workflows.nodes.BlackboardJobNode#generateBlackboardListener(com.googlecode.sarasvati.Engine,
	 * com.googlecode.sarasvati.NodeToken)
	 */
	@Override
	protected BlackboardWorkflowJobListener generateBlackboardListener(final Token token) {
		return new BlackboardWorkflowJobListener(token) {

			@Override
			protected void responseToEnv(final Env env, final Map<String, String> responseParams) {
				env.setAttribute(WorkflowsConstants.MAIN_LOG_PREFIX + "total", responseParams.get("total"));

				final String base64 = responseParams.get("report");
				if (StringUtils.isNotBlank(base64) && Base64.isBase64(base64.getBytes())) {
					final String report = new String(Base64.decodeBase64(base64.getBytes()));
					log.info("found download report");
					log.debug(report);
					env.setAttribute(WorkflowsConstants.MAIN_LOG_PREFIX + "report", report);
				} else {
					log.warn("unable to find or decode download report");
				}
			}
		};
	}

	/**
	 * @return the basepath
	 */
	public String getBasepath() {
		return this.basepath;
	}

	/**
	 * @param basepath
	 *            the basepath to set
	 */
	public void setBasepath(final String basepath) {
		this.basepath = basepath;
	}

}
