package eu.dnetlib.msro.workflows.nodes.stats;

import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import eu.dnetlib.enabling.tools.blackboard.BlackboardJob;
import eu.dnetlib.msro.workflows.procs.Token;

/**
 * Ask the StatsManagerService to refresh the shadow cache according to the content of the shadow stats db for the portal specified by the
 * additional BB parameter <code>StatsManagerServiceBBAction.REFRESH_SHADOW_CACHE.getTargetPortalParamName()</code>.
 * <p>
 * In order for the given portal to actually use the generated cache, we must promote the cache with the BB message 'promoteCache'.
 * </p>
 *
 * @author alessia
 * @see eu.dnetlib.msro.workflows.nodes.stats.PromoteShadowCacheStatsJobNode
 */
public class RefreshShadowCacheJobNode extends AbstractStatsJobNode {

	private static final Log log = LogFactory.getLog(RefreshShadowCacheJobNode.class); // NOPMD by marko on 11/24/08 5:02 PM

	@Override
	protected void prepareJob(final BlackboardJob job, final Token token) throws Exception {
		job.setAction(StatsManagerServiceBBAction.REFRESH_SHADOW_CACHE.action());
		final String portal = getPortalName(token.getEnv());
		if (StringUtils.isNotBlank(portal)) {
			job.getParameters().put(StatsManagerServiceBBAction.REFRESH_SHADOW_CACHE.getTargetPortalParamName(), portal);
		} else {
			log.warn(StatsManagerServiceBBAction.REFRESH_SHADOW_CACHE.getTargetPortalParamName() + " not set. The StatsManagerService will use its default.");
		}
	}

}
