package eu.dnetlib.msro.workflows.nodes.stats;

import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import eu.dnetlib.enabling.tools.blackboard.BlackboardJob;
import eu.dnetlib.msro.workflows.procs.Token;

/**
 * Ask the StatsManagerService to restore the cache of the portal specified by the additional BB parameter
 * <code>StatsManagerServiceBBAction.RESTORE_CACHE.getTargetPortalParamName()</code> to the last available backup.
 * <p>
 * To create a backup you must send a "backup" BB message.
 * </p>
 *
 * @see eu.dnetlib.msro.workflows.nodes.stats.BackupStatsCacheJobNode
 * @author alessia
 *
 */
public class RestoreStatsCacheJobNode extends AbstractStatsJobNode {

	private static final Log log = LogFactory.getLog(RestoreStatsCacheJobNode.class); // NOPMD by marko on 11/24/08 5:02 PM

	@Override
	protected void prepareJob(final BlackboardJob job, final Token token) throws Exception {
		job.setAction(StatsManagerServiceBBAction.RESTORE_CACHE.action());
		final String portal = getPortalName(token.getEnv());
		if (StringUtils.isNotBlank(portal)) {
			job.getParameters().put(StatsManagerServiceBBAction.RESTORE_CACHE.getTargetPortalParamName(), portal);
		} else {
			log.warn(StatsManagerServiceBBAction.RESTORE_CACHE.getTargetPortalParamName() + " not set. The StatsManagerService will use its default.");
		}
	}

}
