package eu.dnetlib.msro.workflows.nodes.vre;

import java.net.URI;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import eu.dnetlib.msro.workflows.graph.Arc;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;
import eu.dnetlib.msro.workflows.procs.Env;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.BasicResponseHandler;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;

/**
 * Created by alessia on 24/03/16.
 */
public class VREPostJobNode extends SimpleJobNode {

	private static final Log log = LogFactory.getLog(VREPostJobNode.class);
	private String scheme;
	private String host;
	private String postPath;

	// POST parameters
	private String appToken;
	private String previewTitle;
	private String previewDescription;
	private String text;
	private String httpImageUrl;
	private boolean enableNotification;

	@Override
	protected String execute(final Env env) throws Exception {
		final CloseableHttpClient httpclient = HttpClients.createDefault();
		try {
			final URI postUri = new URIBuilder().setScheme(this.scheme).setHost(this.host).setPath(this.postPath).build();
			final HttpPost postAction = new HttpPost(postUri);
			final StringBuilder strBuilder = new StringBuilder();
			strBuilder.append("token=").append(this.appToken).append("&previewtitle=").append(this.previewTitle)
					.append("&previewdescription=").append(this.previewDescription).append("&text=").append(this.text)
					.append("&httpimageurl=").append(this.httpImageUrl).append("&enablenotification=").append(this.enableNotification);
			final String postBody = strBuilder.toString();
			log.debug("POST body: " + postBody);
			final StringEntity ent = new StringEntity(postBody, ContentType.APPLICATION_FORM_URLENCODED);

			postAction.setEntity(ent);

			final BasicResponseHandler responseHandler = new BasicResponseHandler();

			httpclient.execute(postAction, responseHandler);
			return Arc.DEFAULT_ARC;
		} finally {
			httpclient.close();
		}

	}

	public String getScheme() {
		return this.scheme;
	}

	public void setScheme(final String scheme) {
		this.scheme = scheme;
	}

	public String getHost() {
		return this.host;
	}

	public void setHost(final String host) {
		this.host = host;
	}

	public String getPostPath() {
		return this.postPath;
	}

	public void setPostPath(final String postPath) {
		this.postPath = postPath;
	}

	public String getAppToken() {
		return this.appToken;
	}

	public void setAppToken(final String token) {
		this.appToken = token;
	}

	public String getPreviewTitle() {
		return this.previewTitle;
	}

	public void setPreviewTitle(final String previewTitle) {
		this.previewTitle = previewTitle;
	}

	public String getPreviewDescription() {
		return this.previewDescription;
	}

	public void setPreviewDescription(final String previewDescription) {
		this.previewDescription = previewDescription;
	}

	public String getText() {
		return this.text;
	}

	public void setText(final String text) {
		this.text = text;
	}

	public String getHttpImageUrl() {
		return this.httpImageUrl;
	}

	public void setHttpImageUrl(final String httpImageUrl) {
		this.httpImageUrl = httpImageUrl;
	}

	public boolean isEnableNotification() {
		return this.enableNotification;
	}

	public void setEnableNotification(final boolean enablenotification) {
		this.enableNotification = enablenotification;
	}
}
