/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.workflows.nodes;

import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.enabling.resultset.factory.ResultSetFactory;
import eu.dnetlib.miscutils.functional.xml.ApplyXslt;
import eu.dnetlib.msro.workflows.graph.Arc;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;
import eu.dnetlib.msro.workflows.procs.Env;
import eu.dnetlib.rmi.common.ResultSet;
import eu.dnetlib.rmi.data.DatabaseService;
import java.io.InputStream;
import java.util.function.Function;
import org.antlr.stringtemplate.StringTemplate;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;

public class FindComplianceRepositoriesJobNode
extends SimpleJobNode {
    private String dbName;
    private final Resource sqlSelectDatasourcesTmpl = new ClassPathResource("/eu/dnetlib/enabling/datasources/getDatasources.sql.st");
    private final Resource xsltFile = new ClassPathResource("/eu/dnetlib/enabling/datasources/repo_2_is.xslt");
    private String eprParam = "repoEpr";
    @Autowired
    private UniqueServiceLocator serviceLocator;
    @Autowired
    private ResultSetFactory resultSetFactory;
    private static final Log log = LogFactory.getLog(FindComplianceRepositoriesJobNode.class);

    protected String execute(Env env) throws Exception {
        StringTemplate st = new StringTemplate(IOUtils.toString((InputStream)this.sqlSelectDatasourcesTmpl.getInputStream()));
        String sql = st.toString();
        log.debug((Object)("Executing query: " + sql));
        ResultSet rs = ((DatabaseService)this.serviceLocator.getService(DatabaseService.class)).searchSQL(this.dbName, sql);
        ResultSet mapped = this.resultSetFactory.map(rs, String.class, (Function)new ApplyXslt(this.xsltFile));
        env.setAttribute(this.getEprParam(), (Object)mapped);
        return Arc.DEFAULT_ARC;
    }

    public String getDbName() {
        return this.dbName;
    }

    public void setDbName(String dbName) {
        this.dbName = dbName;
    }

    public String getEprParam() {
        return this.eprParam;
    }

    public void setEprParam(String eprParam) {
        this.eprParam = eprParam;
    }
}

