/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.workflows.nodes.claims;

import eu.dnetlib.enabling.resultset.factory.ResultSetFactory;
import eu.dnetlib.msro.workflows.graph.Arc;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;
import eu.dnetlib.msro.workflows.nodes.hadoop.SetHdfsFileJobNode;
import eu.dnetlib.msro.workflows.procs.Env;
import eu.dnetlib.rmi.common.ResultSet;
import java.io.Reader;
import java.io.StringReader;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.QName;
import org.dom4j.io.SAXReader;
import org.springframework.beans.factory.annotation.Autowired;

public class DecapsuleClaimsJobNode
extends SimpleJobNode {
    private static final Log log = LogFactory.getLog(SetHdfsFileJobNode.class);
    private static final Namespace OAF_NS = new Namespace("oaf", "http://namespace.openaire.eu/oaf");
    private static final double DEFAULT_TRUST = 0.9;
    private String inputEprParam;
    private String outputEprParam;
    @Autowired
    private ResultSetFactory resultSetFactory;

    protected String execute(Env env) throws Exception {
        SAXReader reader = new SAXReader();
        UnaryOperator mapper = row -> {
            try {
                Document docRow = reader.read((Reader)new StringReader((String)row));
                String xml = docRow.valueOf("//ROW/FIELD[@name = 'xml']");
                String provenance = docRow.valueOf("//ROW/FIELD[@name = 'provenance']");
                Document doc = reader.read((Reader)new StringReader(xml));
                Element record = (Element)doc.selectSingleNode("//*[local-name() = 'record']");
                Element about = record.addElement(new QName("about"));
                Element dataInfo = about.addElement(new QName("datainfo", OAF_NS));
                dataInfo.addElement(new QName("inferred", OAF_NS)).setText("false");
                dataInfo.addElement(new QName("deletedbyinference", OAF_NS)).setText("false");
                dataInfo.addElement(new QName("trust", OAF_NS)).setText(Double.toString(0.9));
                dataInfo.addElement(new QName("inferenceprovenance", OAF_NS)).setText("");
                Element action = dataInfo.addElement(new QName("provenanceaction", OAF_NS));
                action.addAttribute("schemename", "dnet:provenanceActions");
                action.addAttribute("schemeid", "dnet:provenanceActions");
                action.addAttribute("classname", provenance);
                action.addAttribute("classid", provenance);
                return doc.asXML();
            }
            catch (Throwable e) {
                log.error((Object)("Error parsing row: " + row), e);
                throw new IllegalArgumentException("Error parsing row: " + row, e);
            }
        };
        ResultSet inputEpr = (ResultSet)env.getAttribute(this.getInputEprParam(), ResultSet.class);
        ResultSet epr = this.resultSetFactory.map(inputEpr, String.class, (Function)mapper);
        env.setAttribute(this.getOutputEprParam(), (Object)epr);
        return Arc.DEFAULT_ARC;
    }

    public String getInputEprParam() {
        return this.inputEprParam;
    }

    public void setInputEprParam(String inputEprParam) {
        this.inputEprParam = inputEprParam;
    }

    public String getOutputEprParam() {
        return this.outputEprParam;
    }

    public void setOutputEprParam(String outputEprParam) {
        this.outputEprParam = outputEprParam;
    }
}

