/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.workflows.nodes.datacite;

import com.google.common.collect.Maps;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Queue;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SplitterDatasetsIterator {
    private static final Log log = LogFactory.getLog(SplitterDatasetsIterator.class);
    public static String END_QUEUE = "END_QUEUE";
    private Queue<String> publications;
    private Iterable<String> inputEPR;
    private String rootName;

    public SplitterDatasetsIterator(Queue<String> publicationsQueue, Iterable<String> inputEPR, String rootName) {
        this.publications = publicationsQueue;
        this.inputEPR = inputEPR;
        this.rootName = rootName;
    }

    public void populateQueues() {
        if (this.inputEPR == null) {
            return;
        }
        for (String inputXML : this.inputEPR) {
            List<String> publication_extracted = this.extractByTag(new ByteArrayInputStream(inputXML.getBytes(StandardCharsets.UTF_8)), "publication", inputXML);
            if (publication_extracted == null) continue;
            this.publications.addAll(publication_extracted);
        }
        this.publications.add(END_QUEUE);
    }

    private List<String> extractByTag(InputStream inputXML, String tag, String input) {
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            Document doc = dbf.newDocumentBuilder().parse(inputXML);
            XPath xpath = XPathFactory.newInstance().newXPath();
            Node rootNode = (Node)xpath.evaluate("//*[local-name()='" + this.rootName + "']", doc, XPathConstants.NODE);
            NamedNodeMap attributes = rootNode.getAttributes();
            HashMap nameSpaces = Maps.newHashMap();
            for (int i = 0; i < attributes.getLength(); ++i) {
                Node node = attributes.item(i);
                String name = node.getNodeName();
                if (!name.startsWith("xmlns:")) continue;
                nameSpaces.put(StringUtils.substringAfter((String)name, (String)"xmlns:"), node.getNodeValue());
            }
            xpath = XPathFactory.newInstance().newXPath();
            NodeList nodes = (NodeList)xpath.evaluate("//*[local-name()='" + tag + "']/*[local-name()='record']", doc, XPathConstants.NODESET);
            if (nodes != null && nodes.getLength() > 0) {
                ArrayList<String> result = new ArrayList<String>();
                for (int i = 0; i < nodes.getLength(); ++i) {
                    Document currentDoc = dbf.newDocumentBuilder().newDocument();
                    Node imported = currentDoc.importNode(nodes.item(i), true);
                    for (String key : nameSpaces.keySet()) {
                        Element element = (Element)imported;
                        element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + key, (String)nameSpaces.get(key));
                    }
                    Transformer transformer = TransformerFactory.newInstance().newTransformer();
                    DOMSource mydoc = new DOMSource(imported);
                    StringWriter writer = new StringWriter();
                    transformer.transform(mydoc, new StreamResult(writer));
                    String record = writer.toString();
                    result.add(record);
                }
                return result;
            }
        }
        catch (Exception e) {
            log.error((Object)("Error on extracting " + tag), (Throwable)e);
            return null;
        }
        return null;
    }
}

