/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.workflows.nodes.dedup;

import eu.dnetlib.enabling.tools.blackboard.BlackboardJob;
import eu.dnetlib.msro.workflows.nodes.dedup.utils.DedupConfigurationOrchestration;
import eu.dnetlib.msro.workflows.nodes.hadoop.SubmitHadoopJobNode;
import eu.dnetlib.msro.workflows.procs.Token;
import eu.dnetlib.pace.config.DedupConfig;
import eu.dnetlib.rmi.manager.MSROException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DedupConfigurationAwareJobNode
extends SubmitHadoopJobNode {
    public static final String DEDUP_CONF = "dedup.conf";
    private static final Log log = LogFactory.getLog(DedupConfigurationAwareJobNode.class);
    private DedupConfigurationOrchestration dedupConfigurationOrchestration;

    @Override
    protected void prepareJob(BlackboardJob job, Token token) throws Exception {
        super.prepareJob(job, token);
        DedupConfigurationOrchestration conf = this.getDedupConfigurationOrchestration();
        if (conf == null) {
            throw new MSROException("Cannot find dedup configurations in workflow env");
        }
        DedupConfig currentConf = conf.getConfigurations().peek();
        log.debug((Object)("using dedup configuration: '" + currentConf + "'"));
        job.getParameters().put(DEDUP_CONF, currentConf.toString());
        token.getEnv().setAttribute(DEDUP_CONF, (Object)currentConf);
    }

    public DedupConfigurationOrchestration getDedupConfigurationOrchestration() {
        return this.dedupConfigurationOrchestration;
    }

    public void setDedupConfigurationOrchestration(DedupConfigurationOrchestration dedupConfigurationOrchestration) {
        this.dedupConfigurationOrchestration = dedupConfigurationOrchestration;
    }
}

