/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.workflows.nodes.dedup;

import eu.dnetlib.enabling.tools.blackboard.BlackboardJob;
import eu.dnetlib.miscutils.datetime.DateUtils;
import eu.dnetlib.msro.workflows.nodes.BlackboardJobNode;
import eu.dnetlib.msro.workflows.procs.Env;
import eu.dnetlib.msro.workflows.procs.Token;
import eu.dnetlib.rmi.enabling.ISLookUpDocumentNotFoundException;
import eu.dnetlib.rmi.enabling.ISLookUpException;
import eu.dnetlib.rmi.enabling.ISLookUpService;
import eu.dnetlib.rmi.manager.MSROException;
import eu.dnetlib.rmi.provision.IndexService;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FinalizeDedupIndexJobNode
extends BlackboardJobNode {
    private static final Log log = LogFactory.getLog(FinalizeDedupIndexJobNode.class);
    private String actionset;

    protected String obtainServiceId(Env env) {
        return this.getServiceLocator().getServiceId(IndexService.class);
    }

    protected void prepareJob(BlackboardJob job, Token token) throws Exception {
        String indexDsId = this.getEnvParam(token, "index_id");
        log.info((Object)("preparing blackboard job DELETE_BY_QUERY index: " + indexDsId));
        String backendId = this.getBackendId(indexDsId);
        if (StringUtils.isBlank((CharSequence)backendId)) {
            throw new MSROException("empty index backend Id");
        }
        job.setAction("DELETE_BY_QUERY");
        job.getParameters().put("id", indexDsId);
        job.getParameters().put("backend_Id", backendId);
        job.getParameters().put("query", this.buildQuery(this.getEnvParam(token, "entityType"), this.getEnvParam(token, "index.feed.timestamp"), this.getActionset()));
    }

    private String buildQuery(String entityType, String version, String actionset) {
        String query = String.format("__dsversion:{* TO %s} AND oaftype:%s AND actionset:%s", DateUtils.getParsedDateField((String)version), entityType, actionset);
        log.info((Object)("delete by query: " + query));
        return query;
    }

    private String getEnvParam(Token token, String name) throws MSROException {
        String value = (String)token.getEnv().getAttribute(name, String.class);
        if (StringUtils.isBlank((CharSequence)value)) {
            throw new MSROException(String.format("unable to finalize index feeding, cannot find property '%s' in the workflow env.", name));
        }
        return value;
    }

    public String getBackendId(String indexDsId) throws ISLookUpDocumentNotFoundException, ISLookUpException {
        return ((ISLookUpService)this.getServiceLocator().getService(ISLookUpService.class)).getResourceProfileByQuery("//RESOURCE_PROFILE[.//RESOURCE_IDENTIFIER/@value='" + indexDsId + "']//BACKEND/text()");
    }

    public String getActionset() {
        return this.actionset;
    }

    public void setActionset(String actionset) {
        this.actionset = actionset;
    }
}

