/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.workflows.nodes.dedup.utils;

import com.google.common.collect.Lists;
import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.msro.workflows.nodes.dedup.utils.DedupConfigurationOrchestration;
import eu.dnetlib.msro.workflows.nodes.dedup.utils.Entity;
import eu.dnetlib.pace.config.DedupConfig;
import eu.dnetlib.rmi.enabling.ISLookUpException;
import eu.dnetlib.rmi.enabling.ISLookUpService;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class DedupConfigurationOrchestrationLoader {
    private static final Log log = LogFactory.getLog(DedupConfigurationOrchestrationLoader.class);
    @Resource
    private UniqueServiceLocator serviceLocator;

    public DedupConfigurationOrchestration loadByActionSetId(String id) throws Exception {
        ISLookUpService isLookUpService = (ISLookUpService)this.serviceLocator.getService(ISLookUpService.class);
        String xquery = String.format("/RESOURCE_PROFILE[.//DEDUPLICATION/ACTION_SET/@id = '%s']", id);
        log.info((Object)("loading dedup orchestration: " + xquery));
        return this.parseOrchestrationProfile(isLookUpService, isLookUpService.getResourceProfileByQuery(xquery));
    }

    public List<DedupConfigurationOrchestration> loadByEntityName(String entityName) throws Exception {
        ISLookUpService isLookUpService = (ISLookUpService)this.serviceLocator.getService(ISLookUpService.class);
        String xquery = String.format("/RESOURCE_PROFILE[.//DEDUPLICATION/ENTITY/@name = '%s']", entityName);
        log.info((Object)("loading dedup orchestration: " + xquery));
        ArrayList res = Lists.newArrayList();
        for (String profile : isLookUpService.quickSearchProfile(xquery)) {
            res.add(this.parseOrchestrationProfile(isLookUpService, profile));
        }
        return res;
    }

    private DedupConfigurationOrchestration parseOrchestrationProfile(ISLookUpService isLookUpService, String dedupOrchestation) throws DocumentException, ISLookUpException {
        Document doc = new SAXReader().read((Reader)new StringReader(dedupOrchestation));
        Element e = (Element)doc.selectSingleNode("//DEDUPLICATION/ENTITY");
        Entity entity = new Entity(e.attributeValue("name"), e.attributeValue("code"), e.attributeValue("label"));
        String actionSetId = doc.valueOf("//DEDUPLICATION/ACTION_SET/@id");
        LinkedList configurations = Lists.newLinkedList();
        for (Object o : doc.selectNodes("//SCAN_SEQUENCE/SCAN")) {
            configurations.add(this.loadConfig(isLookUpService, actionSetId, o));
        }
        DedupConfigurationOrchestration dco = new DedupConfigurationOrchestration(entity, actionSetId, configurations);
        log.debug((Object)("loaded dedup configuration orchestration: " + dco.toString()));
        log.info((Object)("loaded dedup configuration orchestration, size: " + dco.getConfigurations().size()));
        return dco;
    }

    private DedupConfig loadConfig(ISLookUpService isLookUpService, String actionSetId, Object o) throws ISLookUpException {
        Element s = (Element)o;
        String configProfileId = s.attributeValue("id");
        String conf = isLookUpService.getResourceProfileByQuery(String.format("for $x in /RESOURCE_PROFILE[.//RESOURCE_IDENTIFIER/@value = '%s'] return $x//DEDUPLICATION/text()", configProfileId));
        log.debug((Object)("loaded dedup configuration from IS profile: " + conf));
        if (StringUtils.isBlank((CharSequence)conf)) {
            throw new IllegalStateException(String.format("got empty dedup configuration profile for '%s'", configProfileId));
        }
        DedupConfig dedupConfig = DedupConfig.load((String)conf);
        dedupConfig.getWf().setConfigurationId(actionSetId);
        return dedupConfig;
    }
}

