/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.workflows.nodes.dfm;

import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.monitoring.core.sensors.SensorCreationException;
import eu.dnetlib.monitoring.core.sensors.SensorFactory;
import eu.dnetlib.monitoring.core.sensors.collection.index.solr.SolrSensor;
import eu.dnetlib.msro.workflows.graph.Arc;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;
import eu.dnetlib.msro.workflows.procs.Env;
import eu.dnetlib.rmi.enabling.ISLookUpException;
import java.io.IOException;
import javax.annotation.Resource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TriggerIndexMonitoringScenarioJobNode
extends SimpleJobNode {
    private static final Log log = LogFactory.getLog(TriggerIndexMonitoringScenarioJobNode.class);
    private static final String SOLR_COLLECTION_POSTFIX = "-index-openaire";
    @Resource
    private UniqueServiceLocator serviceLocator;
    private String mdFormat;
    private SolrSensor solrSensor;

    protected String execute(Env env) throws IOException, InstantiationException, IllegalAccessException, InterruptedException, ISLookUpException, SensorCreationException {
        String actualCollection = this.mdFormat + SOLR_COLLECTION_POSTFIX;
        log.info((Object)("Executing on " + actualCollection + " SOLR collection"));
        this.solrSensor = (SolrSensor)SensorFactory.createSensorWithConfiguration(SolrSensor.class, (String)"index", (String)"solr2");
        this.solrSensor.getConfiguration().setParam("collection", (Object)actualCollection);
        this.solrSensor.reinitialize();
        log.info((Object)"Measuring...");
        this.solrSensor.measure();
        log.info((Object)"DONE!");
        return Arc.DEFAULT_ARC;
    }

    public String getMdFormat() {
        return this.mdFormat;
    }

    public void setMdFormat(String mdFormat) {
        this.mdFormat = mdFormat;
    }
}

