/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.workflows.nodes.hadoop;

import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.msro.workflows.graph.Arc;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;
import eu.dnetlib.msro.workflows.procs.Env;
import eu.dnetlib.rmi.data.hadoop.ClusterName;
import eu.dnetlib.rmi.data.hadoop.HadoopService;
import eu.dnetlib.rmi.enabling.ISLookUpException;
import eu.dnetlib.rmi.enabling.ISLookUpService;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class PrepareStatsParamJobNode
extends SimpleJobNode {
    private static final Log log = LogFactory.getLog(PrepareStatsParamJobNode.class);
    private static final String xqueryIsLookupEndpoint = "//RESOURCE_PROFILE[.//RESOURCE_TYPE/@value='IS_LookUpServiceResourceType']//PROTOCOL[./@name='SOAP']/@address/string()";
    @Autowired
    private UniqueServiceLocator serviceLocator;

    protected String execute(Env env) throws Exception {
        log.info((Object)"prepare stats update job");
        Map conf = ((HadoopService)this.serviceLocator.getService(HadoopService.class)).getClusterConfiguration(ClusterName.DM.toString());
        String nameNode = (String)conf.get("fs.defaultFS");
        env.setAttribute("nameNode", (Object)nameNode);
        env.setAttribute("jobTracker", conf.get("mapred.job.tracker"));
        env.setAttribute("isLookupEndpoint", (Object)this.getIsLookupEndpoint());
        return Arc.DEFAULT_ARC;
    }

    private String getIsLookupEndpoint() throws ISLookUpException {
        return ((ISLookUpService)this.serviceLocator.getService(ISLookUpService.class)).getResourceProfileByQuery(xqueryIsLookupEndpoint);
    }
}

