/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.workflows.nodes.index;

import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.miscutils.datetime.DateUtils;
import eu.dnetlib.miscutils.functional.hash.Hashing;
import eu.dnetlib.msro.workflows.graph.Arc;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;
import eu.dnetlib.msro.workflows.procs.Env;
import eu.dnetlib.rmi.enabling.ISLookUpDocumentNotFoundException;
import eu.dnetlib.rmi.enabling.ISLookUpException;
import eu.dnetlib.rmi.enabling.ISLookUpService;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.io.StringWriter;
import javax.annotation.Resource;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.core.io.ClassPathResource;

public class PrepareIndexDataJobNode
extends SimpleJobNode {
    private static final Log log = LogFactory.getLog(PrepareIndexDataJobNode.class);
    public static final String SEPARATOR = "_";
    @Resource
    private UniqueServiceLocator serviceLocator;
    private String layoutToRecordStylesheet;
    private String outputRecordsPathParam;
    private String rottenRecordsPathParam;
    private String hbaseTable;
    private String oafSchemaLocation;

    protected String execute(Env env) throws Exception {
        log.info((Object)"start preparing job");
        String xslt = this.prepareXslt(this.env("format", env), this.env("layout", env));
        env.setAttribute("index.xslt", (Object)xslt);
        if (!StringUtils.isBlank((CharSequence)this.getOutputRecordsPathParam())) {
            env.setAttribute(this.getOutputRecordsPathParam(), (Object)("/tmp" + this.getFileName(env, "indexrecords")));
        }
        if (!StringUtils.isBlank((CharSequence)this.getRottenRecordsPathParam())) {
            env.setAttribute(this.getRottenRecordsPathParam(), (Object)("/tmp" + this.getFileName(env, "rottenrecords")));
        }
        env.setAttribute("index.solr.url", (Object)this.getIndexSolrUrlZk());
        env.setAttribute("index.solr.collection", (Object)this.getCollectionName(env));
        env.setAttribute("index.shutdown.wait.time", (Object)this.getIndexSolrShutdownWait());
        env.setAttribute("index.buffer.flush.threshold", (Object)this.getIndexBufferFlushTreshold());
        env.setAttribute("index.solr.sim.mode", (Object)this.isFeedingSimulationMode());
        env.setAttribute("index.feed.timestamp", (Object)DateUtils.now_ISO8601());
        env.setAttribute("", (Object)this.oafSchemaLocation);
        return Arc.DEFAULT_ARC;
    }

    public String getIndexSolrUrlZk() throws ISLookUpException {
        return this.getServiceConfigValue("for $x in /RESOURCE_PROFILE[.//RESOURCE_TYPE/@value='IndexServiceResourceType'] return $x//PROTOCOL[./@name='solr']/@address/string()");
    }

    public String getIndexSolrShutdownWait() throws ISLookUpException {
        return this.queryForServiceProperty("solr:feedingShutdownTolerance");
    }

    public String getIndexBufferFlushTreshold() throws ISLookUpException {
        return this.queryForServiceProperty("solr:feedingBufferFlushThreshold");
    }

    public String isFeedingSimulationMode() throws ISLookUpException {
        return this.queryForServiceProperty("solr:feedingSimulationMode");
    }

    private String queryForServiceProperty(String key) throws ISLookUpException {
        return this.getServiceConfigValue("for $x in /RESOURCE_PROFILE[.//RESOURCE_TYPE/@value='IndexServiceResourceType'] return $x//SERVICE_PROPERTIES/PROPERTY[./@ key='" + key + "']/@value/string()");
    }

    private String getServiceConfigValue(String xquery) throws ISLookUpException {
        log.debug((Object)("quering for service property: " + xquery));
        String res = ((ISLookUpService)this.serviceLocator.getService(ISLookUpService.class)).getResourceProfileByQuery(xquery);
        if (StringUtils.isBlank((CharSequence)res)) {
            throw new IllegalStateException("unable to find unique service property, xquery: " + xquery);
        }
        return res;
    }

    private String getFileName(Env env, String fileNamePrefix) {
        return "/" + fileNamePrefix + SEPARATOR + this.getHbaseTable() + SEPARATOR + env.getAttribute("format") + ".seq";
    }

    private String getCollectionName(Env env) {
        return this.env("format", env) + SEPARATOR + this.env("layout", env) + SEPARATOR + this.env("interpretation", env);
    }

    private String env(String s, Env env) {
        return (String)env.getAttribute(s, String.class);
    }

    protected String prepareXslt(String format, String layout) throws ISLookUpException, IOException, TransformerException {
        TransformerFactory factory = TransformerFactory.newInstance();
        Transformer layoutTransformer = factory.newTransformer(new StreamSource(new StringReader(this.readXslt(this.getLayoutToRecordStylesheet()))));
        StreamResult layoutToXsltXslt = new StreamResult(new StringWriter());
        layoutTransformer.setParameter("format", format);
        layoutTransformer.transform(new StreamSource(new StringReader(this.getLayoutSource(format, layout))), layoutToXsltXslt);
        return new String(Hashing.encodeBase64((String)layoutToXsltXslt.getWriter().toString()));
    }

    private String readXslt(String s) throws IOException {
        ClassPathResource resource = new ClassPathResource(s);
        InputStream inputStream = resource.getInputStream();
        return IOUtils.toString((InputStream)inputStream);
    }

    private String getLayoutSource(String format, String layout) throws ISLookUpDocumentNotFoundException, ISLookUpException {
        return ((ISLookUpService)this.serviceLocator.getService(ISLookUpService.class)).getResourceProfileByQuery("collection('')//RESOURCE_PROFILE[.//RESOURCE_TYPE/@value = 'MDFormatDSResourceType' and .//NAME='" + format + "']//LAYOUT[@name='" + layout + "']");
    }

    public String getLayoutToRecordStylesheet() {
        return this.layoutToRecordStylesheet;
    }

    public void setLayoutToRecordStylesheet(String layoutToRecordStylesheet) {
        this.layoutToRecordStylesheet = layoutToRecordStylesheet;
    }

    public String getHbaseTable() {
        return this.hbaseTable;
    }

    @Required
    public void setHbaseTable(String hbaseTable) {
        this.hbaseTable = hbaseTable;
    }

    public String getOutputRecordsPathParam() {
        return this.outputRecordsPathParam;
    }

    public void setOutputRecordsPathParam(String outputRecordsPathParam) {
        this.outputRecordsPathParam = outputRecordsPathParam;
    }

    public String getRottenRecordsPathParam() {
        return this.rottenRecordsPathParam;
    }

    public void setRottenRecordsPathParam(String rottenRecordsPathParam) {
        this.rottenRecordsPathParam = rottenRecordsPathParam;
    }

    public void setOafSchemaLocation(String oafSchemaLocation) {
        this.oafSchemaLocation = oafSchemaLocation;
    }
}

