/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.workflows.nodes.objectstore;

import eu.dnetlib.miscutils.functional.xml.DnetXsltFunctions;
import eu.dnetlib.msro.workflows.nodes.objectstore.IteratorRepository;
import eu.dnetlib.rmi.data.ObjectStoreFile;
import eu.dnetlib.rmi.data.Protocols;
import java.io.File;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ArxivIteratorRepository
extends IteratorRepository {
    private final Pattern pattern = Pattern.compile("[0-9]");

    public ArxivIteratorRepository(Iterable<File> input, String repositoryPrefix, String oaiPrefix) {
        super(input, repositoryPrefix, oaiPrefix);
    }

    @Override
    String generateNextElement() {
        try {
            String inputname = ((File)this.input.next()).getCanonicalPath();
            String[] values = inputname.split("/");
            if (values.length > 1) {
                ObjectStoreFile info = new ObjectStoreFile();
                String fileName = values[values.length - 1].replace(".pdf", "");
                Matcher matcher = this.pattern.matcher(fileName);
                if (matcher.find() && matcher.start() != 0) {
                    fileName = fileName.substring(0, matcher.start()) + "/" + fileName.substring(matcher.start());
                }
                info.setDownloadedURL("http://arxiv.org/abs/" + fileName);
                info.setAccessProtocol(Protocols.None);
                String value = this.oaiPrefix + fileName;
                String resultID = this.repositoryPrefix + "::" + DnetXsltFunctions.md5((String)value);
                info.setObjectID(resultID + "::" + DnetXsltFunctions.md5((String)info.getDownloadedURL()));
                info.setMimeType("pdf");
                info.setURI(inputname);
                return info.toJSON();
            }
        }
        catch (Exception e) {
            return null;
        }
        return null;
    }
}

