/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.workflows.nodes.objectstore;

import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.enabling.tools.blackboard.BlackboardJob;
import eu.dnetlib.msro.workflows.nodes.blackboard.BlackboardWorkflowJobListener;
import eu.dnetlib.msro.workflows.nodes.download.DownloadFromMetadataJobNode;
import eu.dnetlib.msro.workflows.procs.Env;
import eu.dnetlib.msro.workflows.procs.Token;
import eu.dnetlib.rmi.data.ObjectStoreService;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class DownloadFromMetadataOpenaire
extends DownloadFromMetadataJobNode {
    private static final Log log = LogFactory.getLog(DownloadFromMetadataOpenaire.class);
    private String basepath;
    @Autowired
    private UniqueServiceLocator serviceLocator;

    protected void prepareJob(BlackboardJob job, Token token) throws Exception {
        if (this.getBasepath() != null && this.getBasepath().length() > 0) {
            job.getParameters().put("basePath", this.basepath);
        }
        int size = ((ObjectStoreService)this.serviceLocator.getService(ObjectStoreService.class)).getSize(this.getObjectStoreID());
        log.debug((Object)String.format("objectStore %s has size %s", this.getObjectStoreID(), size));
        token.getEnv().setAttribute("mainlog:oldTotal", (Object)size);
        super.prepareJob(job, token);
    }

    protected BlackboardWorkflowJobListener generateBlackboardListener(Token token) {
        return new BlackboardWorkflowJobListener(token){

            protected void responseToEnv(Env env, Map<String, String> responseParams) {
                env.setAttribute("mainlog:total", (Object)responseParams.get("total"));
                String base64 = responseParams.get("report");
                if (StringUtils.isNotBlank((CharSequence)base64) && Base64.isBase64((byte[])base64.getBytes())) {
                    String report = new String(Base64.decodeBase64((byte[])base64.getBytes()));
                    log.info((Object)"found download report");
                    log.debug((Object)report);
                    env.setAttribute("mainlog:report", (Object)report);
                } else {
                    log.warn((Object)"unable to find or decode download report");
                }
            }
        };
    }

    public String getBasepath() {
        return this.basepath;
    }

    public void setBasepath(String basepath) {
        this.basepath = basepath;
    }
}

