/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.workflows.nodes.objectstore;

import eu.dnetlib.enabling.resultset.client.ResultSetClient;
import eu.dnetlib.enabling.resultset.factory.ResultSetFactory;
import eu.dnetlib.enabling.tools.blackboard.BlackboardJob;
import eu.dnetlib.msro.workflows.nodes.BlackboardJobNode;
import eu.dnetlib.msro.workflows.nodes.objectstore.ArxivIteratorRepository;
import eu.dnetlib.msro.workflows.nodes.objectstore.IteratorRepository;
import eu.dnetlib.msro.workflows.nodes.objectstore.PUMAIteratorRepository;
import eu.dnetlib.msro.workflows.nodes.objectstore.RepositoryNoURLIterator;
import eu.dnetlib.msro.workflows.procs.Env;
import eu.dnetlib.msro.workflows.procs.Token;
import eu.dnetlib.msro.workflows.util.ProgressProvider;
import eu.dnetlib.msro.workflows.util.ResultsetProgressProvider;
import eu.dnetlib.rmi.common.ResultSet;
import eu.dnetlib.rmi.data.ObjectStoreService;
import eu.dnetlib.rmi.data.Protocols;
import java.io.File;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.springframework.beans.factory.annotation.Autowired;

public class ImportFilesJobNode
extends BlackboardJobNode {
    private String basePath;
    private String repositoryPrefix;
    private String oaiPrefix;
    private String objectStoreId;
    private String contentDescription;
    @Autowired
    private ResultSetFactory resultSetFactory;
    @Autowired
    private ResultSetClient resultSetClient;

    public String getRepositoryPrefix() {
        return this.repositoryPrefix;
    }

    public void setRepositoryPrefix(String repositoryPrefix) {
        this.repositoryPrefix = repositoryPrefix;
    }

    public String getBasePath() {
        return this.basePath;
    }

    public void setBasePath(String basePath) {
        this.basePath = basePath;
    }

    protected String obtainServiceId(Env env) {
        return this.getServiceLocator().getServiceId(ObjectStoreService.class);
    }

    protected void prepareJob(BlackboardJob job, Token token) throws Exception {
        File dir = new File(this.basePath);
        System.out.println("Getting all files in " + dir.getCanonicalPath() + " including those in subdirectories");
        List files = (List)FileUtils.listFiles((File)dir, (IOFileFilter)TrueFileFilter.INSTANCE, (IOFileFilter)TrueFileFilter.INSTANCE);
        IteratorRepository irepo = this.repositoryPrefix.equals("od________18") ? new ArxivIteratorRepository(files, this.repositoryPrefix, this.oaiPrefix) : (this.repositoryPrefix.equals("od______2367") ? new PUMAIteratorRepository(files, this.repositoryPrefix, this.oaiPrefix) : new RepositoryNoURLIterator(files, this.repositoryPrefix, this.oaiPrefix));
        ResultSet epr = this.resultSetFactory.createResultSet((Iterable)irepo);
        token.setProgressProvider((ProgressProvider)new ResultsetProgressProvider(epr, this.resultSetClient));
        job.setAction("FEED");
        job.getParameters().put("obsID", this.getObjectStoreId());
        job.getParameters().put("mime", this.getContentDescription());
        job.getParameters().put("protocol", Protocols.File_System.toString());
        job.getParameters().put("epr", epr.toJson());
    }

    public String getObjectStoreId() {
        return this.objectStoreId;
    }

    public void setObjectStoreId(String objectStoreId) {
        this.objectStoreId = objectStoreId;
    }

    public String getContentDescription() {
        return this.contentDescription;
    }

    public void setContentDescription(String contentDescription) {
        this.contentDescription = contentDescription;
    }

    public String getOaiPrefix() {
        return this.oaiPrefix;
    }

    public void setOaiPrefix(String oaiPrefix) {
        this.oaiPrefix = oaiPrefix;
    }
}

