package eu.dnetlib.pace.clustering;

import java.util.Collection;
import java.util.List;
import java.util.Map;

import com.google.common.collect.Sets;

import eu.dnetlib.pace.common.AbstractPaceFunctions;
import eu.dnetlib.pace.model.Field;

public abstract class AbstractClusteringFunction extends AbstractPaceFunctions implements ClusteringFunction {

	protected Map<String, Integer> params;
	
	public AbstractClusteringFunction(final Map<String, Integer> params) {
		this.params = params;
	}
	
	protected abstract Collection<String> doApply(String s);
	
	@Override
	public Collection<String> apply(List<Field> fields) {
		Collection<String> c = Sets.newLinkedHashSet();
		for(Field f : fields) {
			c.addAll(filterBlacklisted(doApply(filterStopWords(normalize(f.stringValue()), stopwords)), ngramBlacklist));
		}
		return c;
	}

	public Map<String, Integer> getParams() {
		return params;
	}
	
	protected Integer param(String name) {
		return params.get(name);
	}
}
