/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.pace.model;

import com.google.gson.Gson;
import eu.dnetlib.pace.clustering.Acronyms;
import eu.dnetlib.pace.clustering.Clustering;
import eu.dnetlib.pace.clustering.ClusteringFunction;
import eu.dnetlib.pace.clustering.ImmutableFieldValue;
import eu.dnetlib.pace.clustering.NgramPairs;
import eu.dnetlib.pace.clustering.Ngrams;
import eu.dnetlib.pace.clustering.PersonClustering;
import eu.dnetlib.pace.clustering.PersonHash;
import eu.dnetlib.pace.clustering.RandomClusteringFunction;
import eu.dnetlib.pace.clustering.SortedNgramPairs;
import eu.dnetlib.pace.clustering.SpaceTrimmingFieldValue;
import eu.dnetlib.pace.clustering.SuffixPrefix;
import java.util.List;
import java.util.Map;

public class ClusteringDef {
    private Clustering name;
    private List<String> fields;
    private Map<String, Integer> params;

    public Clustering getName() {
        return this.name;
    }

    public void setName(Clustering name) {
        this.name = name;
    }

    public ClusteringFunction getClusteringFunction() {
        switch (this.getName()) {
            case acronyms: {
                return new Acronyms(this.getParams());
            }
            case ngrams: {
                return new Ngrams(this.getParams());
            }
            case ngrampairs: {
                return new NgramPairs(this.getParams());
            }
            case sortedngrampairs: {
                return new SortedNgramPairs(this.getParams());
            }
            case suffixprefix: {
                return new SuffixPrefix(this.getParams());
            }
            case spacetrimmingfieldvalue: {
                return new SpaceTrimmingFieldValue(this.getParams());
            }
            case immutablefieldvalue: {
                return new ImmutableFieldValue(this.getParams());
            }
            case personhash: {
                return new PersonHash(this.getParams());
            }
            case personclustering: {
                return new PersonClustering(this.getParams());
            }
        }
        return new RandomClusteringFunction(this.getParams());
    }

    public List<String> getFields() {
        return this.fields;
    }

    public void setFields(List<String> fields) {
        this.fields = fields;
    }

    public Map<String, Integer> getParams() {
        return this.params;
    }

    public void setParams(Map<String, Integer> params) {
        this.params = params;
    }

    public String toString() {
        return new Gson().toJson((Object)this);
    }
}

