/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.pace.model;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.gson.Gson;
import eu.dnetlib.pace.config.Type;
import eu.dnetlib.pace.model.AbstractField;
import eu.dnetlib.pace.model.Field;
import eu.dnetlib.pace.model.FieldList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public class FieldListImpl
extends AbstractField
implements FieldList {
    private List<Field> fields = Lists.newArrayList();

    public FieldListImpl() {
    }

    public FieldListImpl(String name, Type type) {
        super(type, name);
    }

    @Override
    public boolean add(Field f) {
        return this.fields.add(f);
    }

    @Override
    public void add(int i, Field f) {
        this.fields.add(i, f);
    }

    @Override
    public boolean addAll(Collection<? extends Field> f) {
        return this.fields.addAll(f);
    }

    @Override
    public boolean addAll(int i, Collection<? extends Field> f) {
        return this.fields.addAll(i, f);
    }

    @Override
    public void clear() {
        this.fields.clear();
    }

    @Override
    public boolean contains(Object o) {
        return this.fields.contains(o);
    }

    @Override
    public boolean containsAll(Collection<?> f) {
        return this.fields.containsAll(f);
    }

    @Override
    public Field get(int i) {
        return this.fields.get(i);
    }

    @Override
    public int indexOf(Object o) {
        return this.fields.indexOf(o);
    }

    @Override
    public boolean isEmpty() {
        return Iterables.all(this.fields, (Predicate)new Predicate<Field>(){

            public boolean apply(Field f) {
                return f.isEmpty();
            }
        });
    }

    @Override
    public Iterator<Field> iterator() {
        return this.fields.iterator();
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.fields.lastIndexOf(o);
    }

    @Override
    public ListIterator<Field> listIterator() {
        return this.fields.listIterator();
    }

    @Override
    public ListIterator<Field> listIterator(int i) {
        return this.fields.listIterator(i);
    }

    @Override
    public boolean remove(Object o) {
        return this.fields.remove(o);
    }

    @Override
    public Field remove(int i) {
        return this.fields.remove(i);
    }

    @Override
    public boolean removeAll(Collection<?> f) {
        return this.fields.removeAll(f);
    }

    @Override
    public boolean retainAll(Collection<?> f) {
        return this.fields.retainAll(f);
    }

    @Override
    public Field set(int i, Field f) {
        return this.fields.set(i, f);
    }

    @Override
    public int size() {
        return this.fields.size();
    }

    @Override
    public List<Field> subList(int from, int to) {
        return this.fields.subList(from, to);
    }

    @Override
    public Object[] toArray() {
        return this.fields.toArray();
    }

    @Override
    public <T> T[] toArray(T[] t) {
        return this.fields.toArray(t);
    }

    @Override
    public String stringValue() {
        switch (this.getType()) {
            case List: 
            case Int: 
            case String: {
                return Joiner.on((String)" ").join(this.stringList());
            }
            case JSON: {
                String json = new Gson().toJson(this.stringList());
                return json;
            }
        }
        throw new IllegalArgumentException("Unknown type: " + this.getType().toString());
    }

    @Override
    public List<String> stringList() {
        return Lists.newArrayList((Iterable)Iterables.transform(this.fields, this.getValuesTransformer()));
    }

    private Function<Field, String> getValuesTransformer() {
        return new Function<Field, String>(){

            public String apply(Field f) {
                return f.stringValue();
            }
        };
    }

    public String toString() {
        return this.stringList().toString();
    }
}

