/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.pace.clustering;

import com.google.common.collect.Sets;
import eu.dnetlib.pace.clustering.AbstractClusteringFunction;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;

public class Acronyms
extends AbstractClusteringFunction {
    public Acronyms(Map<String, Integer> params) {
        super(params);
    }

    @Override
    protected Collection<String> doApply(String s) {
        return this.extractAcronyms(s, this.param("max"), this.param("minLen"), this.param("maxLen"));
    }

    private Set<String> extractAcronyms(String s, int maxAcronyms, int minLen, int maxLen) {
        LinkedHashSet acronyms = Sets.newLinkedHashSet();
        for (int i = 0; i < maxAcronyms; ++i) {
            String acronym;
            StringTokenizer st = new StringTokenizer(s);
            StringBuilder sb = new StringBuilder();
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                if (sb.length() > maxLen) break;
                if (token.length() <= 1 || i >= token.length()) continue;
                sb.append(token.charAt(i));
            }
            if ((acronym = sb.toString()).length() <= minLen) continue;
            acronyms.add(acronym);
        }
        return acronyms;
    }
}

