/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.pace.model;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import eu.dnetlib.pace.model.Document;
import eu.dnetlib.pace.model.Field;
import eu.dnetlib.pace.model.MapDocumentSerializer;
import java.util.Map;
import java.util.Set;

public class MapDocument
implements Document {
    private String identifier;
    private Map<String, Field> fieldMap;

    public MapDocument() {
        this.identifier = null;
        this.fieldMap = Maps.newHashMap();
    }

    public MapDocument(String identifier, Map<String, Field> fieldMap) {
        this.setIdentifier(identifier);
        this.fieldMap = fieldMap;
    }

    public MapDocument(String identifier, byte[] data) {
        MapDocument doc = MapDocumentSerializer.decode(data);
        this.fieldMap = doc.fieldMap;
        this.identifier = doc.identifier;
    }

    @Override
    public Iterable<Field> fields() {
        return Lists.newArrayList((Iterable)Iterables.concat(this.fieldMap.values()));
    }

    @Override
    public Field values(String name) {
        return this.fieldMap.get(name);
    }

    @Override
    public Set<String> fieldNames() {
        return this.fieldMap.keySet();
    }

    public String toString() {
        return MapDocumentSerializer.toString(this);
    }

    public byte[] toByteArray() {
        return MapDocumentSerializer.toByteArray(this);
    }

    @Override
    public String getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    public Map<String, Field> getFieldMap() {
        return this.fieldMap;
    }

    public void setFieldMap(Map<String, Field> fieldMap) {
        this.fieldMap = fieldMap;
    }
}

