package eu.dnetlib.pace.clustering;

import java.util.Collection;
import java.util.List;
import java.util.Map;

import com.google.common.collect.Lists;
import eu.dnetlib.pace.model.adaptor.Pid;

public class PidClustering extends AbstractClusteringFunction {

	public PidClustering(final Map<String, Integer> params) {
		super(params);
	}

	@Override
	protected Collection<String> doApply(final String s) {

		final List<String> res = Lists.newArrayList();

		final Pid pid = Pid.fromOafJson(s);

		final StringBuilder sb = new StringBuilder();
		sb.append(pid.getValue()).append(pid.getType());
		res.add(sb.toString());

		return res;
	}

}
