package eu.dnetlib.pace.distance.algo;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;

import com.google.common.base.Function;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.google.common.collect.Sets.SetView;
import eu.dnetlib.pace.distance.ConfigurableDistanceAlgo;
import eu.dnetlib.pace.distance.DistanceAlgo;
import eu.dnetlib.pace.model.Field;
import eu.dnetlib.pace.model.FieldListImpl;
import eu.dnetlib.pace.model.gt.CoAuthor;
import eu.dnetlib.pace.model.gt.CoAuthors;
import eu.dnetlib.pace.model.gt.GTAuthor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PersonCoAnchorsDistance extends ConfigurableDistanceAlgo implements DistanceAlgo {

	/**
	 * logger.
	 */
	private static final Log log = LogFactory.getLog(PersonCoAnchorsDistance.class); // NOPMD by marko on 11/24/08 5:02 PM

	public PersonCoAnchorsDistance(final Map<String, String> params, final double weight) {
		super(params, weight);
	}

	@Override
	public double distance(final Field a, final Field b) {

		final GTAuthor ga = Iterables.getLast(GTAuthor.fromDNGFJson(((FieldListImpl) a).stringList()));
		final GTAuthor gb = Iterables.getLast(GTAuthor.fromDNGFJson(((FieldListImpl) b).stringList()));

		final Integer commonAnchors = Integer.parseInt(getParams().get("common.anchors"));
		// log.info("min common anchors: " + commonAnchors);
		if (isEnabled(commonAnchors) && (anchorsInCommon(ga, gb).size() >= commonAnchors)) // log.info("matched coauthor intersection");
			return 1.0;

		return 0;
	}

	private boolean isEnabled(final Integer property) {
		return (property != null) && (property >= 0);
	}

	private Set<String> anchorsInCommon(final GTAuthor a, final GTAuthor b) {
		final SetView<String> intersection = Sets.intersection(getAnchorIds(a.getCoAuthors()), getAnchorIds(b.getCoAuthors()));
		//log.info(String.format("anchors intersection '%s' - '%s': %s", a.getAuthor().getFullname(), b.getAuthor().getFullname(), intersection.size()));
		return intersection;
	}

	private Set<String> getAnchorIds(final CoAuthors ca) {
		if ((ca == null) || ca.isEmpty()) return new HashSet<String>();
		final Iterable<String> anchorIds = Iterables.transform(ca, new Function<CoAuthor, String>() {

			@Override
			public String apply(final CoAuthor c) {
				return c.getAnchorId();
			}
		});
		final Iterable<String> filtered = Iterables.filter(anchorIds, Predicates.notNull());
		return Sets.newHashSet(filtered);
	}

	@Override
	public double getWeight() {
		return getWeigth();
	}

}
