package eu.dnetlib.pace.distance.algo;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;

import eu.dnetlib.pace.distance.ConfigurableDistanceAlgo;
import eu.dnetlib.pace.distance.DistanceAlgo;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.google.common.base.Function;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.google.common.collect.Sets.SetView;

import eu.dnetlib.pace.model.Field;
import eu.dnetlib.pace.model.FieldListImpl;
import eu.dnetlib.pace.model.gt.CoAuthor;
import eu.dnetlib.pace.model.gt.CoAuthors;
import eu.dnetlib.pace.model.gt.GTAuthor;

public class PersonCoAuthorSurnamesDistance extends ConfigurableDistanceAlgo implements DistanceAlgo {

	/**
	 * logger.
	 */
	private static final Log log = LogFactory.getLog(PersonCoAuthorSurnamesDistance.class); // NOPMD by marko on 11/24/08 5:02 PM

	public PersonCoAuthorSurnamesDistance(final Map<String, String> params, final double weight) {
		super(params, weight);
	}

	@Override
	public double distance(final Field a, final Field b) {

		final GTAuthor ga = Iterables.getOnlyElement(GTAuthor.fromDNGFJson(((FieldListImpl) a).stringList()));
		final GTAuthor gb = Iterables.getOnlyElement(GTAuthor.fromDNGFJson(((FieldListImpl) b).stringList()));

		final Integer commonSurnames = Integer.parseInt(getParams().get("common.surnames"));
		// log.info("min common surnames: " + commonSurnames);
		if (isEnabled(commonSurnames) && (surnamesInCommon(ga, gb).size() >= commonSurnames)) return 1.0;

		return 0;
	}

	private boolean isEnabled(final Integer property) {
		return (property != null) && (property >= 0);
	}

	private Set<String> surnamesInCommon(final GTAuthor a, final GTAuthor b) {
		final SetView<String> intersection = Sets.intersection(getSurnames(a.getCoAuthors()), getSurnames(b.getCoAuthors()));
		// log.info(String.format("surnames intersection '%s' - '%s': %s", a.getAuthor().getFullname(), b.getAuthor().getFullname(),
		// intersection.size()));
		return intersection;
	}

	private Set<String> getSurnames(final CoAuthors ca) {
		if ((ca == null) || ca.isEmpty()) return new HashSet<String>();
		return Sets.newHashSet(Iterables.filter(Iterables.transform(ca, new Function<CoAuthor, String>() {

			@Override
			public String apply(final CoAuthor c) {
				return c.getSecondnames();
			}
		}), Predicates.notNull()));
	}

	@Override
	public double getWeight() {
		return getWeigth();
	}

}
