/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.pace.distance.algo;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import eu.dnetlib.pace.distance.ConfigurableDistanceAlgo;
import eu.dnetlib.pace.distance.DistanceAlgo;
import eu.dnetlib.pace.model.Field;
import eu.dnetlib.pace.model.FieldListImpl;
import eu.dnetlib.pace.model.gt.CoAuthor;
import eu.dnetlib.pace.model.gt.CoAuthors;
import eu.dnetlib.pace.model.gt.GTAuthor;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PersonCoAuthorSurnamesDistance
extends ConfigurableDistanceAlgo
implements DistanceAlgo {
    private static final Log log = LogFactory.getLog(PersonCoAuthorSurnamesDistance.class);

    public PersonCoAuthorSurnamesDistance(Map<String, String> params, double weight) {
        super(params, weight);
    }

    @Override
    public double distance(Field a, Field b) {
        GTAuthor ga = (GTAuthor)Iterables.getOnlyElement(GTAuthor.fromDNGFJson(((FieldListImpl)a).stringList()));
        GTAuthor gb = (GTAuthor)Iterables.getOnlyElement(GTAuthor.fromDNGFJson(((FieldListImpl)b).stringList()));
        Integer commonSurnames = Integer.parseInt(this.getParams().get("common.surnames"));
        if (this.isEnabled(commonSurnames) && this.surnamesInCommon(ga, gb).size() >= commonSurnames) {
            return 1.0;
        }
        return 0.0;
    }

    private boolean isEnabled(Integer property) {
        return property != null && property >= 0;
    }

    private Set<String> surnamesInCommon(GTAuthor a, GTAuthor b) {
        Sets.SetView intersection = Sets.intersection(this.getSurnames(a.getCoAuthors()), this.getSurnames(b.getCoAuthors()));
        return intersection;
    }

    private Set<String> getSurnames(CoAuthors ca) {
        if (ca == null || ca.isEmpty()) {
            return new HashSet<String>();
        }
        return Sets.newHashSet((Iterable)Iterables.filter((Iterable)Iterables.transform((Iterable)ca, (Function)new Function<CoAuthor, String>(){

            public String apply(CoAuthor c) {
                return c.getSecondnames();
            }
        }), (Predicate)Predicates.notNull()));
    }

    @Override
    public double getWeight() {
        return this.getWeigth();
    }
}

