/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.pace.model;

import com.google.common.collect.Iterables;
import eu.dnetlib.pace.clustering.NGramUtils;
import eu.dnetlib.pace.model.Document;
import eu.dnetlib.pace.model.Field;
import eu.dnetlib.pace.model.FieldList;
import eu.dnetlib.pace.model.FieldListImpl;
import java.util.Comparator;

public class MapDocumentComparator
implements Comparator<Document> {
    private String comparatorField;
    private final FieldList emptyField = new FieldListImpl();

    public MapDocumentComparator(String comparatorField) {
        this.comparatorField = comparatorField;
    }

    @Override
    public int compare(Document d1, Document d2) {
        if (d1.values(this.comparatorField).isEmpty() || d2.values(this.comparatorField).isEmpty()) {
            return 0;
        }
        String o1 = ((Field)Iterables.getFirst((Iterable)d1.values(this.comparatorField), (Object)this.emptyField)).stringValue();
        String o2 = ((Field)Iterables.getFirst((Iterable)d2.values(this.comparatorField), (Object)this.emptyField)).stringValue();
        if (o1 == null || o2 == null) {
            return 0;
        }
        String to1 = NGramUtils.cleanupForOrdering(o1);
        String to2 = NGramUtils.cleanupForOrdering(o2);
        return to1.compareTo(to2);
    }
}

