/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.pace.model.gt;

import com.google.common.base.Function;
import com.google.common.collect.ComparisonChain;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Ordering;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import eu.dnetlib.pace.model.gt.Author;
import eu.dnetlib.pace.model.gt.Authors;
import eu.dnetlib.pace.model.gt.CoAuthors;
import eu.dnetlib.pace.model.gt.GTAuthorOafSerialiser;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;

public class GTAuthor
implements Comparable<GTAuthor> {
    private String id;
    private Author author;
    private Authors merged;
    private CoAuthors coAuthors;
    private boolean anchor;

    public GTAuthor() {
    }

    public GTAuthor(String id, Authors merged, CoAuthors coAuthors, boolean anchor) {
        if (merged == null || merged.isEmpty()) {
            throw new IllegalArgumentException("empty merged author set, id: " + id);
        }
        this.author = this.pickAuthor(merged);
        this.id = id;
        this.merged = merged;
        this.coAuthors = coAuthors;
        this.anchor = anchor;
    }

    private Author pickAuthor(Authors merged) {
        List<AuthorFrequency> freq = this.getFrequencies(merged);
        Collections.sort(freq, Collections.reverseOrder(new Comparator<AuthorFrequency>(){

            @Override
            public int compare(AuthorFrequency o1, AuthorFrequency o2) {
                return ComparisonChain.start().compare(o1.getFullname().length(), o2.getFullname().length()).compare((Comparable)o1.getFrequency(), (Comparable)o2.getFrequency()).result();
            }
        }));
        return (Author)Iterables.getFirst(freq, null);
    }

    private List<AuthorFrequency> getFrequencies(Authors merged) {
        final HashMap countMap = Maps.newHashMap();
        for (Author a : merged) {
            Integer count = (Integer)countMap.get(a.getFullname());
            if (count == null) {
                countMap.put(a.getFullname(), new Integer(1));
                continue;
            }
            countMap.put(a.getFullname(), count + 1);
        }
        return Lists.newArrayList((Iterable)Iterables.transform((Iterable)merged, (Function)new Function<Author, AuthorFrequency>(){

            public AuthorFrequency apply(Author a) {
                AuthorFrequency af = new AuthorFrequency(a);
                Integer freq = (Integer)countMap.get(af.getFullname());
                af.setFrequency(freq);
                return af;
            }
        }));
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Author getAuthor() {
        return this.author;
    }

    public void setAuthor(Author author) {
        this.author = author;
    }

    public boolean hasMerged() {
        return this.getMerged() != null && !this.getMerged().isEmpty();
    }

    public Authors getMerged() {
        return this.merged;
    }

    public void setMerged(Authors merged) {
        this.merged = merged;
    }

    public boolean hasCoAuthors() {
        return this.getCoAuthors() != null && !this.getCoAuthors().isEmpty();
    }

    public CoAuthors getCoAuthors() {
        return this.coAuthors;
    }

    public void setCoAuthors(CoAuthors coAuthors) {
        this.coAuthors = coAuthors;
    }

    public boolean isAnchor() {
        return this.anchor;
    }

    public void setAnchor(boolean anchor) {
        this.anchor = anchor;
    }

    public static GTAuthor fromJson(String json) {
        Gson gson = new Gson();
        return (GTAuthor)gson.fromJson(json, GTAuthor.class);
    }

    public static List<GTAuthor> fromDNGFJson(List<String> json) {
        GsonBuilder gb = new GsonBuilder();
        gb.registerTypeAdapter(GTAuthor.class, (Object)new GTAuthorOafSerialiser());
        Gson gson = gb.create();
        return Lists.newArrayList((Iterable)Iterables.transform(json, s -> (GTAuthor)gson.fromJson(s, GTAuthor.class)));
    }

    public static GTAuthor fromDNGFJson(String json) {
        GsonBuilder gb = new GsonBuilder();
        gb.registerTypeAdapter(GTAuthor.class, (Object)new GTAuthorOafSerialiser());
        Gson gson = gb.create();
        return (GTAuthor)gson.fromJson(json, GTAuthor.class);
    }

    public String toString() {
        return new Gson().toJson((Object)this);
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    @Override
    public int compareTo(GTAuthor o) {
        return ComparisonChain.start().compare((Object)this.getId(), (Object)o.getId(), (Comparator)Ordering.natural().nullsLast()).result();
    }

    public boolean equals(Object o) {
        return o instanceof GTAuthor && this.getId().equals(((GTAuthor)o).getId());
    }

    class AuthorFrequency
    extends Author {
        private Integer frequency;

        public AuthorFrequency(Author a) {
            super(a);
            this.frequency = new Integer(1);
        }

        public void increment() {
            this.setFrequency(this.getFrequency() + 1);
        }

        public Integer getFrequency() {
            return this.frequency;
        }

        public void setFrequency(Integer frequency) {
            this.frequency = frequency;
        }
    }
}

