/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.pace.distance.algo;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import eu.dnetlib.pace.distance.ConfigurableDistanceAlgo;
import eu.dnetlib.pace.distance.DistanceAlgo;
import eu.dnetlib.pace.model.Field;
import eu.dnetlib.pace.model.FieldListImpl;
import eu.dnetlib.pace.model.gt.CoAuthor;
import eu.dnetlib.pace.model.gt.CoAuthors;
import eu.dnetlib.pace.model.gt.GTAuthor;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PersonDistance
extends ConfigurableDistanceAlgo
implements DistanceAlgo {
    private static final Log log = LogFactory.getLog(PersonDistance.class);
    private Integer commonAnchors = null;
    private Integer commonSurnames = null;

    public PersonDistance(Map<String, String> params, double weight) {
        super(params, weight);
        String commonAnchors = this.getParams().get("common.anchors");
        this.commonAnchors = this.isEnabled(commonAnchors) ? Integer.valueOf(Integer.parseInt(commonAnchors)) : null;
        log.debug((Object)("min common anchors: " + commonAnchors));
        String commonSurnames = this.getParams().get("common.surnames");
        this.commonSurnames = this.isEnabled(commonSurnames) ? Integer.valueOf(Integer.parseInt(commonSurnames)) : null;
        log.debug((Object)("min common surnames: " + commonSurnames));
    }

    @Override
    public double distance(Field a, Field b) {
        GTAuthor ga = (GTAuthor)Iterables.getLast(GTAuthor.fromDNGFJson(((FieldListImpl)a).stringList()));
        GTAuthor gb = (GTAuthor)Iterables.getLast(GTAuthor.fromDNGFJson(((FieldListImpl)b).stringList()));
        if (this.commonAnchors != null && this.anchorsInCommon(ga, gb).size() >= this.commonAnchors) {
            return 1.0;
        }
        if (this.commonSurnames != null && this.surnamesInCommon(ga, gb).size() >= this.commonSurnames) {
            return 1.0;
        }
        return 0.0;
    }

    private boolean isEnabled(String property) {
        return property != null && Integer.parseInt(property) >= 0;
    }

    private Set<String> anchorsInCommon(GTAuthor a, GTAuthor b) {
        Sets.SetView set = Sets.intersection(this.getAnchorIds(a.getCoAuthors()), this.getAnchorIds(b.getCoAuthors()));
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("anchors intersection '%s' - '%s': size: %s, %s", a.getAuthor().getFullname(), b.getAuthor().getFullname(), set.size(), set));
        }
        return set;
    }

    private Set<String> getAnchorIds(CoAuthors ca) {
        if (ca == null || ca.isEmpty()) {
            return new HashSet<String>();
        }
        Iterable anchorIds = Iterables.transform((Iterable)ca, (Function)new Function<CoAuthor, String>(){

            public String apply(CoAuthor c) {
                return c.getAnchorId();
            }
        });
        Iterable filtered = Iterables.filter((Iterable)anchorIds, (Predicate)Predicates.notNull());
        return Sets.newHashSet((Iterable)filtered);
    }

    private Set<String> surnamesInCommon(GTAuthor a, GTAuthor b) {
        Sets.SetView set = Sets.intersection(this.getSurnames(a.getCoAuthors()), this.getSurnames(b.getCoAuthors()));
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("surnames intersection '%s' - '%s' size: %s, %s", a.getAuthor().getFullname(), b.getAuthor().getFullname(), set.size(), set));
        }
        return set;
    }

    private Set<String> getSurnames(CoAuthors ca) {
        if (ca == null || ca.isEmpty()) {
            return new HashSet<String>();
        }
        return Sets.newHashSet((Iterable)Iterables.filter((Iterable)Iterables.transform((Iterable)ca, (Function)new Function<CoAuthor, String>(){

            public String apply(CoAuthor c) {
                return c.getSecondnames();
            }
        }), (Predicate)Predicates.notNull()));
    }

    @Override
    public double getWeight() {
        return this.getWeigth();
    }
}

