/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.pace.clustering;

import com.google.common.base.Predicate;
import eu.dnetlib.pace.model.Field;
import java.util.List;
import java.util.Map;

public class FieldFilter
implements Predicate<Field> {
    private Map<String, List<String>> blacklists;
    private String filedName;

    public FieldFilter(String fieldName, Map<String, List<String>> blacklists) {
        this.filedName = fieldName;
        this.blacklists = blacklists;
    }

    public boolean apply(Field f) {
        return !this.regexMatches(this.filedName, f.stringValue(), this.blacklists);
    }

    protected boolean regexMatches(String fieldName, String value, Map<String, List<String>> blacklists) {
        if (blacklists.containsKey(fieldName)) {
            Iterable regexes = blacklists.get(fieldName);
            for (String regex : regexes) {
                if (!value.matches(regex)) continue;
                return true;
            }
        }
        return false;
    }
}

