/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.pace.config;

import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import eu.dnetlib.pace.condition.ConditionAlgo;
import eu.dnetlib.pace.config.Config;
import eu.dnetlib.pace.config.PaceConfig;
import eu.dnetlib.pace.config.WfConfig;
import eu.dnetlib.pace.model.ClusteringDef;
import eu.dnetlib.pace.model.FieldDef;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.antlr.stringtemplate.StringTemplate;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DedupConfig
implements Config {
    private static final Log log = LogFactory.getLog(DedupConfig.class);
    private static String CONFIG_TEMPLATE = "dedupConfig.st";
    private PaceConfig pace;
    private WfConfig wf;
    private static Map<String, String> defaults = Maps.newHashMap();

    public static DedupConfig load(String json) {
        DedupConfig config = (DedupConfig)new Gson().fromJson(json, DedupConfig.class);
        config.getPace().initModel();
        return config;
    }

    public static DedupConfig loadDefault() throws IOException {
        return DedupConfig.loadDefault(new HashMap<String, String>());
    }

    public static DedupConfig loadDefault(Map<String, String> params) throws IOException {
        StringTemplate template = new StringTemplate(new DedupConfig().readFromClasspath(CONFIG_TEMPLATE));
        for (Map.Entry<String, String> e : defaults.entrySet()) {
            template.setAttribute(e.getKey(), (Object)e.getValue());
        }
        for (Map.Entry<String, String> e : params.entrySet()) {
            template.setAttribute(e.getKey(), (Object)e.getValue());
        }
        String json = template.toString();
        return DedupConfig.load(json);
    }

    private String readFromClasspath(String resource) throws IOException {
        return IOUtils.toString((URL)this.getClass().getResource(resource));
    }

    public PaceConfig getPace() {
        return this.pace;
    }

    public void setPace(PaceConfig pace) {
        this.pace = pace;
    }

    public WfConfig getWf() {
        return this.wf;
    }

    public void setWf(WfConfig wf) {
        this.wf = wf;
    }

    public String toString() {
        return new GsonBuilder().setPrettyPrinting().create().toJson((Object)this);
    }

    @Override
    public List<FieldDef> model() {
        return this.getPace().getModel();
    }

    @Override
    public Map<String, FieldDef> modelMap() {
        return this.getPace().getModelMap();
    }

    @Override
    public List<ConditionAlgo> strictConditions() {
        return this.getPace().getStrictConditionAlgos();
    }

    @Override
    public List<ConditionAlgo> conditions() {
        return this.getPace().getConditionAlgos();
    }

    @Override
    public List<ClusteringDef> clusterings() {
        return this.getPace().getClustering();
    }

    @Override
    public Map<String, List<String>> blacklists() {
        return this.getPace().getBlacklists();
    }

    static {
        defaults.put("threshold", "0");
        defaults.put("run", "001");
        defaults.put("entityType", "result");
        defaults.put("orderField", "title");
        defaults.put("queueMaxSize", "2000");
        defaults.put("groupMaxSize", "10");
        defaults.put("slidingWindowSize", "200");
        defaults.put("rootBuilder", "result");
        defaults.put("includeChildren", "true");
    }
}

