/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.pace.distance;

import com.wcohen.ss.AbstractStringDistance;
import eu.dnetlib.pace.common.AbstractPaceFunctions;
import eu.dnetlib.pace.config.Type;
import eu.dnetlib.pace.distance.DistanceAlgo;
import eu.dnetlib.pace.model.Field;
import eu.dnetlib.pace.model.FieldList;
import java.util.List;

public abstract class SecondStringDistanceAlgo
extends AbstractPaceFunctions
implements DistanceAlgo {
    protected AbstractStringDistance ssalgo;
    protected double weight = 0.0;

    protected SecondStringDistanceAlgo(double weight, AbstractStringDistance ssalgo) {
        this.ssalgo = ssalgo;
        this.weight = weight;
    }

    protected abstract double normalize(double var1);

    public double distance(String a, String b) {
        double score = this.ssalgo.score(a, b);
        return this.normalize(score);
    }

    protected double distance(List<String> a, List<String> b) {
        return this.distance(this.concat(a), this.concat(b));
    }

    @Override
    public double distance(Field a, Field b) {
        if (a.getType().equals((Object)Type.String) && b.getType().equals((Object)Type.String)) {
            return this.distance(a.stringValue(), b.stringValue());
        }
        if (a.getType().equals((Object)Type.List) && b.getType().equals((Object)Type.List)) {
            return this.distance(this.toList(a), this.toList(b));
        }
        throw new IllegalArgumentException("invalid types\n- A: " + a.toString() + "\n- B: " + b.toString());
    }

    protected List<String> toList(Field list) {
        return ((FieldList)list).stringList();
    }
}

